/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.GroupingHandlerDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class GroupingHandlerAdd
extends AbstractAddStepHandler {
    public static final GroupingHandlerAdd INSTANCE = new GroupingHandlerAdd(GroupingHandlerDefinition.ATTRIBUTES);

    private GroupingHandlerAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : GroupingHandlerDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
            if (server.getGroupingHandler() != null) {
                throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.childResourceAlreadyExists("grouping-handler"));
            }
            if (context.isNormalServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        context.reloadRequired();
                        context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }

    static void addGroupingHandlerConfig(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("grouping-handler")) {
            Property prop = model.get("grouping-handler").asProperty();
            String name = prop.getName();
            ModelNode node = prop.getValue();
            GroupingHandlerConfiguration.TYPE type = GroupingHandlerConfiguration.TYPE.valueOf((String)GroupingHandlerDefinition.TYPE.resolveModelAttribute(context, node).asString());
            String address = GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS.resolveModelAttribute(context, node).asString();
            int timeout = GroupingHandlerDefinition.TIMEOUT.resolveModelAttribute(context, node).asInt();
            long groupTimeout = GroupingHandlerDefinition.GROUP_TIMEOUT.resolveModelAttribute(context, node).asLong();
            long reaperPeriod = GroupingHandlerDefinition.REAPER_PERIOD.resolveModelAttribute(context, node).asLong();
            GroupingHandlerConfiguration conf = new GroupingHandlerConfiguration().setName(SimpleString.toSimpleString((String)name)).setType(type).setAddress(SimpleString.toSimpleString((String)address)).setTimeout((long)timeout).setGroupTimeout(groupTimeout).setReaperPeriod(reaperPeriod);
            configuration.setGroupingHandlerConfiguration(conf);
        }
    }
}

