/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheStream;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CacheFilters;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.FilterNullValueConverter;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class VersionedCallInterceptor
extends DDAsyncInterceptor {
    private final InfinispanDataRegion region;
    private final Metadata expiringMetadata;
    @Inject
    private AdvancedCache cache;
    private Metadata defaultMetadata;

    public VersionedCallInterceptor(InfinispanDataRegion region) {
        this.region = region;
        this.expiringMetadata = new EmbeddedMetadata.Builder().lifespan(region.getTombstoneExpiration(), TimeUnit.MILLISECONDS).build();
    }

    @Start
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.cacheConfiguration.expiration().lifespan()).maxIdle(this.cacheConfiguration.expiration().maxIdle()).build();
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long newTimestamp;
        Object newVersion;
        Object newValue;
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        Object oldValue = e.getValue();
        Object oldVersion = null;
        long oldTimestamp = Long.MIN_VALUE;
        if (oldValue instanceof VersionedEntry) {
            oldVersion = ((VersionedEntry)oldValue).getVersion();
            oldTimestamp = ((VersionedEntry)oldValue).getTimestamp();
            oldValue = ((VersionedEntry)oldValue).getValue();
        } else {
            oldVersion = this.findVersion(oldValue);
        }
        Object actualNewValue = newValue = command.getValue();
        boolean isRemoval = false;
        String subclass = null;
        if (newValue instanceof VersionedEntry) {
            VersionedEntry ve = (VersionedEntry)newValue;
            newVersion = ve.getVersion();
            newTimestamp = ve.getTimestamp();
            if (ve.getValue() == null) {
                isRemoval = true;
            } else if (ve.getValue() instanceof CacheEntry) {
                actualNewValue = ve.getValue();
                subclass = ((CacheEntry)ve.getValue()).getSubclass();
            } else if (ve.getValue() instanceof Map) {
                actualNewValue = ve.getValue();
                Object maybeSubclass = ((Map)ve.getValue()).get("_subclass");
                if (maybeSubclass instanceof String) {
                    subclass = (String)maybeSubclass;
                }
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(newValue));
        }
        if (newVersion == null) {
            this.setValue(e, newValue, this.expiringMetadata, command);
            return null;
        }
        if (oldVersion == null) {
            assert (oldValue == null || oldTimestamp != Long.MIN_VALUE);
            if (newTimestamp <= oldTimestamp) {
                assert (oldValue == null);
            } else {
                this.setValue(e, actualNewValue, this.defaultMetadata, command);
            }
            return null;
        }
        Comparator<Object> versionComparator = null;
        if (subclass != null) {
            versionComparator = this.region.getComparator(subclass);
        }
        if (versionComparator == null) {
            this.setValue(e, new VersionedEntry(null, null, newTimestamp), this.expiringMetadata, command);
        } else {
            int compareResult = versionComparator.compare(newVersion, oldVersion);
            if (isRemoval && compareResult >= 0) {
                this.setValue(e, actualNewValue, this.expiringMetadata, command);
            } else if (compareResult > 0) {
                this.setValue(e, actualNewValue, this.defaultMetadata, command);
            }
        }
        return null;
    }

    private Object findVersion(Object entry) {
        if (entry instanceof CacheEntry) {
            return ((CacheEntry)entry).getVersion();
        }
        if (entry instanceof Map) {
            return ((Map)entry).get("_version");
        }
        return null;
    }

    private Object setValue(MVCCEntry e, Object value, Metadata metadata, PutKeyValueCommand command) {
        if (e.isRemoved()) {
            e.setRemoved(false);
            e.setCreated(true);
            e.setValid(true);
        } else {
            e.setChanged(true);
        }
        command.setMetadata(metadata);
        e.setMetadata(metadata);
        return e.setValue(value);
    }

    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        Set flags = command.getFlags();
        boolean size = false;
        AdvancedCache decoratedCache = this.cache.getAdvancedCache();
        if (flags != null) {
            decoratedCache = decoratedCache.withFlags(flags.toArray(new Flag[flags.size()]));
        }
        return Math.min(Integer.MAX_VALUE, (int)CacheFilters.filterAndConvert((CacheStream)decoratedCache.entrySet().stream(), new FilterNullValueConverter<Object, Object>(VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE)).count());
    }
}

