/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jboss.as.clustering.controller.ExecutionHandler;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class MetricHandler<C>
extends ExecutionHandler<C, Metric<C>>
implements Registration<ManagementResourceRegistration> {
    private final Collection<? extends Metric<C>> metrics;

    public <M extends Enum<M>> MetricHandler(MetricExecutor<C> executor, Class<M> metricClass) {
        this(executor, EnumSet.allOf(metricClass));
    }

    public MetricHandler(MetricExecutor<C> executor, Metric<C>[] metrics) {
        this(executor, Arrays.asList(metrics));
    }

    public MetricHandler(MetricExecutor<C> executor, Collection<? extends Metric<C>> metrics) {
        super(executor, metrics, Metric::getName, Operations::getAttributeName);
        this.metrics = metrics;
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (Metric<C> metric : this.metrics) {
            registration.registerReadOnlyAttribute((AttributeDefinition)metric.getDefinition(), (OperationStepHandler)this);
        }
    }
}

