/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.aesh.readline.Prompt;
import org.aesh.readline.cursor.CursorLocator;
import org.aesh.readline.util.IntArrayBuilder;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.readline.util.Parser;
import org.aesh.readline.util.WcWidth;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

public class Buffer {
    private static final Logger LOGGER = LoggerUtil.getLogger(Buffer.class.getName());
    private int[] line;
    private int cursor;
    private int size;
    private Prompt prompt;
    private int delta;
    private boolean deltaChangedAtEndOfBuffer = true;
    private boolean disablePrompt = false;
    private boolean multiLine = false;
    private int[] multiLineBuffer = new int[0];
    private boolean isPromptDisplayed = false;
    private boolean deletingBackward = true;
    private final CursorLocator locator;

    Buffer() {
        this.line = new int[1024];
        this.prompt = new Prompt("");
        this.locator = new CursorLocator(this);
    }

    Buffer(Prompt prompt) {
        this.line = new int[1024];
        this.prompt = prompt != null ? prompt : new Prompt("");
        this.locator = new CursorLocator(this);
    }

    public Buffer(Buffer buf) {
        this.line = (int[])buf.line.clone();
        this.cursor = buf.cursor;
        this.size = buf.size;
        this.prompt = buf.prompt.copy();
        this.locator = new CursorLocator(this);
    }

    public CursorLocator getCursorLocator() {
        return this.locator;
    }

    public int get(int pos) {
        if (pos > -1 && pos <= this.size) {
            return this.line[pos];
        }
        throw new IndexOutOfBoundsException();
    }

    public int cursor() {
        return this.cursor;
    }

    public int multiCursor() {
        if (this.multiLine) {
            return this.multiLineBuffer.length + this.cursor;
        }
        return this.cursor;
    }

    public boolean isMasking() {
        return this.prompt.isMasking();
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public String asString() {
        return Parser.fromCodePoints(this.multiLine());
    }

    public void reset() {
        this.cursor = 0;
        for (int i = 0; i < this.size; ++i) {
            this.line[i] = 0;
        }
        this.size = 0;
        this.isPromptDisplayed = false;
        if (this.multiLine) {
            this.multiLineBuffer = new int[0];
            this.multiLine = false;
        }
        this.locator.clear();
    }

    public void setIsPromptDisplayed(boolean isPromptDisplayed) {
        this.isPromptDisplayed = isPromptDisplayed;
    }

    public void forceSetDeltaChangedAtEndOfBuffer(boolean delta) {
        this.deltaChangedAtEndOfBuffer = delta;
    }

    public void disablePrompt(boolean disable) {
        this.disablePrompt = disable;
    }

    public boolean isPromptDisabled() {
        return this.disablePrompt;
    }

    void setPrompt(Prompt prompt, Consumer<int[]> out, int width) {
        if (prompt != null) {
            this.delta = prompt.getLength() - this.prompt.getLength();
            this.prompt = prompt;
            this.print(out, width);
        }
    }

    public Prompt prompt() {
        return this.prompt;
    }

    public int length() {
        if (this.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return 1;
        }
        return this.size;
    }

    private int promptLength() {
        return this.disablePrompt ? 0 : this.prompt.getLength();
    }

    public void setMultiLine(boolean multi) {
        if (!this.isMasking()) {
            this.multiLine = multi;
        }
    }

    public void invalidateCursorLocation() {
        if (this.isMultiLine()) {
            this.locator.invalidateCursorLocation();
        }
    }

    public void updateMultiLineBuffer() {
        int cmdSize;
        int originalSize = this.multiLineBuffer.length;
        if (this.lineEndsWithBackslash()) {
            cmdSize = this.size - 1;
            this.multiLineBuffer = Arrays.copyOf(this.multiLineBuffer, originalSize + this.size - 1);
            System.arraycopy(this.line, 0, this.multiLineBuffer, originalSize, this.size - 1);
        } else {
            cmdSize = this.size;
            this.multiLineBuffer = Arrays.copyOf(this.multiLineBuffer, originalSize + this.size);
            System.arraycopy(this.line, 0, this.multiLineBuffer, originalSize, this.size);
        }
        this.locator.addLine(cmdSize, this.prompt.getLength());
        this.clear();
        this.prompt = new Prompt("> ");
        this.cursor = 0;
        this.size = 0;
    }

    private boolean lineEndsWithBackslash() {
        return this.size > 0 && this.line[this.size - 1] == 92;
    }

    public void insert(Consumer<int[]> out, int[] data, int width) {
        this.doInsert(data);
        this.printInsertedData(out, width);
    }

    public void insert(Consumer<int[]> out, int data, int width) {
        this.doInsert(data);
        this.printInsertedData(out, width);
    }

    private void doInsert(int data) {
        int width = WcWidth.width(data);
        if (width != -1 && width == 1) {
            if (this.cursor < this.size) {
                System.arraycopy(this.line, this.cursor, this.line, this.cursor + 1, this.size - this.cursor);
            }
            this.line[this.cursor++] = data;
            ++this.size;
            ++this.delta;
            if (this.size == this.line.length) {
                this.line = Arrays.copyOf(this.line, this.line.length + this.line.length / 2);
            }
            this.deltaChangedAtEndOfBuffer = this.size == this.cursor;
        }
    }

    private void doInsert(int[] data) {
        boolean gotControlChar = false;
        for (int aData : data) {
            int width = WcWidth.width(aData);
            if (width != -1) continue;
            gotControlChar = true;
        }
        if (!gotControlChar) {
            this.doActualInsert(data);
        }
    }

    private void doActualInsert(int[] data) {
        if (data.length > this.line.length - this.size) {
            this.line = Arrays.copyOf(this.line, this.line.length - this.size + data.length + 1);
        }
        if (this.cursor < this.size) {
            System.arraycopy(this.line, this.cursor, this.line, this.cursor + data.length, this.size - this.cursor);
        }
        for (int aData : data) {
            this.line[this.cursor++] = aData;
        }
        this.size += data.length;
        this.delta += data.length;
        this.deltaChangedAtEndOfBuffer = this.size == this.cursor;
    }

    public void move(Consumer<int[]> out, int move, int termWidth) {
        this.move(out, move, termWidth, false);
    }

    public void move(Consumer<int[]> out, int move, int termWidth, boolean viMode) {
        if ((move = this.calculateActualMovement(move, viMode)) == 0) {
            return;
        }
        if (this.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return;
        }
        out.accept(this.syncCursor(this.promptLength() + this.cursor, this.promptLength() + this.cursor + move, termWidth));
        this.cursor += move;
    }

    private int[] syncCursor(int currentPos, int newPos, int width) {
        IntArrayBuilder builder = new IntArrayBuilder();
        if (newPos < 1) {
            newPos = 1;
        }
        if (currentPos / width == newPos / width) {
            if (currentPos > newPos) {
                builder.append(this.moveNumberOfColumns(currentPos - newPos, 'D'));
            } else {
                builder.append(this.moveNumberOfColumns(newPos - currentPos, 'C'));
            }
        } else {
            int moveToLine = currentPos / width - newPos / width;
            int moveToColumn = currentPos % width - newPos % width;
            char rowDirection = 'A';
            if (moveToLine < 0) {
                rowDirection = 'B';
                moveToLine = Math.abs(moveToLine);
            }
            builder.append(this.moveNumberOfColumnsAndRows(moveToLine, rowDirection, moveToColumn));
        }
        return builder.toArray();
    }

    private int[] syncCursorWhenBufferIsAtTerminalEdge(int currentPos, int newPos, int width) {
        IntArrayBuilder builder = new IntArrayBuilder();
        if ((currentPos - 1) / width == newPos / width) {
            builder.append(this.moveNumberOfColumns(width, 'D'));
        } else {
            int moveToLine = (currentPos - 1) / width - newPos / width;
            int moveToColumn = -currentPos;
            char rowDirection = 'A';
            if (moveToLine < 0) {
                rowDirection = 'B';
                moveToLine = Math.abs(moveToLine);
            }
            builder.append(this.moveNumberOfColumnsAndRows(moveToLine, rowDirection, width));
        }
        builder.append(this.moveNumberOfColumns(newPos % width, 'C'));
        return builder.toArray();
    }

    public int[] moveNumberOfColumns(int column, char direction) {
        if (column < 10) {
            int[] out = new int[]{27, 91, 48 + column, direction};
            return out;
        }
        int[] asciiColumn = this.intToAsciiInts(column);
        int[] out = new int[3 + asciiColumn.length];
        out[0] = 27;
        out[1] = 91;
        System.arraycopy(asciiColumn, 0, out, 2, asciiColumn.length);
        out[out.length - 1] = direction;
        return out;
    }

    private int[] moveNumberOfColumnsAndRows(int row, char rowCommand, int column) {
        int direction = 68;
        if (column < 0) {
            column = Math.abs(column);
            direction = 67;
        }
        if (row < 10 && column < 10) {
            int[] out = new int[]{27, 91, 48 + row, rowCommand, 27, 91, 48 + column, direction};
            return out;
        }
        int[] asciiRow = this.intToAsciiInts(row);
        int[] asciiColumn = this.intToAsciiInts(column);
        int[] out = new int[6 + asciiColumn.length + asciiRow.length];
        out[0] = 27;
        out[1] = 91;
        System.arraycopy(asciiRow, 0, out, 2, asciiRow.length);
        out[2 + asciiRow.length] = rowCommand;
        out[3 + asciiRow.length] = 27;
        out[4 + asciiRow.length] = 91;
        for (int i = 0; i < asciiColumn.length; ++i) {
            out[5 + asciiRow.length + i] = asciiColumn[i];
        }
        out[out.length - 1] = direction;
        return out;
    }

    private int calculateActualMovement(int move, boolean viMode) {
        if (this.cursor() == 0 && move <= 0) {
            return 0;
        }
        if (viMode ? this.cursor() == this.length() - 1 && move > 0 : this.cursor() == this.length() && move > 0) {
            return 0;
        }
        if (this.cursor() + move <= 0) {
            return -this.cursor();
        }
        if (viMode) {
            if (this.cursor() + move > this.length() - 1) {
                return this.length() - 1 - this.cursor();
            }
        } else if (this.cursor() + move > this.length()) {
            return this.length() - this.cursor();
        }
        return move;
    }

    private int[] getLineFrom(int position) {
        return Arrays.copyOfRange(this.line, position, this.size);
    }

    public int[] getLineMasked() {
        if (!this.isMasking()) {
            return Arrays.copyOf(this.line, this.size);
        }
        if (this.size > 0 && this.prompt.getMask().charValue() != '\u0000') {
            int[] tmpLine = new int[this.size];
            Arrays.fill(tmpLine, (int)this.prompt.getMask().charValue());
            return tmpLine;
        }
        return new int[0];
    }

    private int[] getLine() {
        return Arrays.copyOf(this.line, this.size);
    }

    public void clear() {
        Arrays.fill(this.line, 0, this.size, 0);
        this.cursor = 0;
        this.size = 0;
        this.isPromptDisplayed = false;
    }

    void print(Consumer<int[]> out, int width) {
        this.print(out, width, false);
    }

    private void print(Consumer<int[]> out, int width, boolean viMode) {
        if (this.delta >= 0) {
            this.printInsertedData(out, width);
        } else {
            this.printDeletedData(out, width, viMode);
        }
        this.delta = 0;
    }

    private void printInsertedData(Consumer<int[]> out, int width) {
        IntArrayBuilder builder = new IntArrayBuilder();
        if (!this.isPromptDisplayed) {
            if (this.promptLength() > 0) {
                builder.append(this.prompt.getANSI());
            }
            this.isPromptDisplayed = true;
            if (this.delta == 0) {
                this.delta = this.cursor;
            }
        }
        if (this.size == 0) {
            out.accept(builder.toArray());
            return;
        }
        if (this.isMasking()) {
            if (this.prompt.getMask().charValue() != '\u0000') {
                int[] mask = new int[this.delta];
                Arrays.fill(mask, (int)this.prompt.getMask().charValue());
                builder.append(mask);
            } else {
                out.accept(builder.toArray());
                this.delta = 0;
                this.deltaChangedAtEndOfBuffer = true;
            }
        } else if (this.deltaChangedAtEndOfBuffer) {
            if (this.delta == 1 || this.delta == 0) {
                if (this.cursor > 0) {
                    builder.append(new int[]{this.line[this.cursor - 1]});
                } else {
                    builder.append(new int[]{this.line[0]});
                }
            } else {
                builder.append(Arrays.copyOfRange(this.line, this.cursor - this.delta, this.cursor));
            }
        } else {
            builder.append(Arrays.copyOfRange(this.line, this.cursor - this.delta, this.size));
        }
        if ((this.size + this.promptLength()) % width == 0 && this.deltaChangedAtEndOfBuffer) {
            builder.append(new int[]{32, 13});
        }
        if (!this.deltaChangedAtEndOfBuffer) {
            if ((this.size + this.promptLength()) % width == 0 && Config.isOSPOSIXCompatible()) {
                builder.append(this.syncCursorWhenBufferIsAtTerminalEdge(this.size + this.promptLength(), this.cursor + this.promptLength(), width));
            } else {
                builder.append(this.syncCursor(this.size + this.promptLength(), this.cursor + this.promptLength(), width));
            }
        }
        out.accept(builder.toArray());
        this.delta = 0;
        this.deltaChangedAtEndOfBuffer = true;
    }

    private void printDeletedData(Consumer<int[]> out, int width, boolean viMode) {
        if (this.isMasking() && this.prompt.getMask().charValue() == '\u0000') {
            return;
        }
        IntArrayBuilder builder = new IntArrayBuilder();
        if (this.size + this.promptLength() + Math.abs(this.delta) >= width) {
            if (this.deletingBackward) {
                if (this.deltaChangedAtEndOfBuffer && (this.size + this.promptLength() + 1) % width > Math.abs(this.delta)) {
                    this.quickDeleteAtEnd(out, viMode);
                    return;
                }
                this.clearAllLinesAndReturnToFirstLine(builder, width, this.cursor + this.promptLength() + Math.abs(this.delta), this.size + this.promptLength() + Math.abs(this.delta));
            } else {
                this.clearAllLinesAndReturnToFirstLine(builder, width, this.cursor + this.promptLength(), this.size + this.promptLength() + Math.abs(this.delta));
            }
        }
        if (this.size + this.promptLength() + 1 < width && this.deltaChangedAtEndOfBuffer) {
            this.quickDeleteAtEnd(out, viMode);
        } else {
            this.moveCursorToStartAndPrint(out, builder, width, false, viMode);
        }
    }

    private void quickDeleteAtEnd(Consumer<int[]> out, boolean viMode) {
        IntArrayBuilder builder = new IntArrayBuilder();
        if (this.deletingBackward) {
            builder.append(this.moveNumberOfColumns(Math.abs(this.delta), 'D'));
        }
        builder.append(ANSI.ERASE_LINE_FROM_CURSOR);
        if (viMode && this.cursor == this.size) {
            builder.append(this.moveNumberOfColumns(1, 'D'));
            --this.cursor;
        }
        out.accept(builder.toArray());
    }

    public void replace(Consumer<int[]> out, String line, int width) {
        this.replace(out, Parser.toCodePoints(line), width);
    }

    public void replace(Consumer<int[]> out, int[] line, int width) {
        if (line == null || this.size == 0 && line.length == 0) {
            return;
        }
        int tmpDelta = line.length - this.size;
        int oldSize = this.size + this.promptLength();
        int oldCursor = this.cursor + this.promptLength();
        this.clear();
        this.doInsert(line);
        this.delta = tmpDelta;
        this.deltaChangedAtEndOfBuffer = this.cursor == this.size;
        IntArrayBuilder builder = new IntArrayBuilder();
        if (oldSize >= width) {
            this.clearAllLinesAndReturnToFirstLine(builder, width, oldCursor, oldSize);
        }
        this.moveCursorToStartAndPrint(out, builder, width, true, false);
        this.delta = 0;
        this.deltaChangedAtEndOfBuffer = true;
    }

    private void clearAllLinesAndReturnToFirstLine(IntArrayBuilder builder, int width, int oldCursor, int oldSize) {
        block7: {
            if (oldSize < width) break block7;
            int cursorRow = oldCursor / width;
            int totalRows = oldSize / width;
            if (oldSize % width == 0 && oldSize == oldCursor) {
                cursorRow = (oldCursor - 1) / width;
                builder.append(ANSI.MOVE_LINE_UP);
            }
            if (totalRows > cursorRow && this.delta < 0) {
                int i;
                for (i = 0; i < totalRows - cursorRow; ++i) {
                    builder.append(ANSI.MOVE_LINE_DOWN);
                }
                for (i = 0; i < totalRows; ++i) {
                    builder.append(ANSI.ERASE_WHOLE_LINE);
                    builder.append(ANSI.MOVE_LINE_UP);
                }
            } else {
                for (int i = 0; i < cursorRow; ++i) {
                    if (this.delta < 0) {
                        builder.append(ANSI.ERASE_WHOLE_LINE);
                    }
                    builder.append(ANSI.MOVE_LINE_UP);
                }
            }
        }
    }

    private void moveCursorToStartAndPrint(Consumer<int[]> out, IntArrayBuilder builder, int width, boolean replace, boolean viMode) {
        if (this.promptLength() > 0 && this.cursor != 0 || this.delta < 0) {
            if (replace) {
                builder.append(this.moveNumberOfColumns(width, 'D'));
            } else {
                int length = this.promptLength() + this.cursor;
                if (length > 0 && length % width == 0) {
                    length = width;
                } else {
                    length %= width;
                    if (this.delta < 0 && this.deletingBackward) {
                        length += Math.abs(this.delta);
                    }
                }
                builder.append(this.moveNumberOfColumns(length, 'D'));
            }
            builder.append(ANSI.ERASE_LINE_FROM_CURSOR);
        }
        if (this.promptLength() > 0) {
            builder.append(this.prompt.getANSI());
        }
        if (this.size > 0) {
            if (this.isMasking()) {
                if (this.prompt.getMask().charValue() != '\u0000') {
                    int[] mask = new int[this.size];
                    Arrays.fill(mask, (int)this.prompt.getMask().charValue());
                    builder.append(mask);
                }
            } else {
                builder.append(this.getLine());
            }
        }
        if ((this.size + this.promptLength()) % width == 0 && this.cursor == this.size) {
            builder.append(new int[]{32, 13});
        }
        if (!this.deltaChangedAtEndOfBuffer) {
            if ((this.size + this.promptLength()) % width == 0 && Config.isOSPOSIXCompatible()) {
                builder.append(this.syncCursor(this.size + this.promptLength() - 1, this.cursor + this.promptLength(), width));
            } else {
                builder.append(this.syncCursor(this.size + this.promptLength(), this.cursor + this.promptLength(), width));
            }
        } else if (viMode && this.cursor == this.size) {
            builder.append(this.moveNumberOfColumns(1, 'D'));
            --this.cursor;
        }
        out.accept(builder.toArray());
        this.isPromptDisplayed = true;
    }

    public int[] multiLine() {
        if (this.multiLine) {
            int[] tmpLine = Arrays.copyOf(this.multiLineBuffer, this.multiLineBuffer.length + this.size);
            System.arraycopy(this.line, 0, tmpLine, this.multiLineBuffer.length, this.size);
            return tmpLine;
        }
        return this.getLine();
    }

    public void delete(Consumer<int[]> out, int delta, int width) {
        this.delete(out, delta, width, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(Consumer<int[]> out, int delta, int width, boolean viMode) {
        if (delta > 0) {
            if ((delta = Math.min(delta, this.size - this.cursor)) <= 0) return;
            System.arraycopy(this.line, this.cursor + delta, this.line, this.cursor, this.size - this.cursor + delta);
            this.size -= delta;
            this.delta = -delta;
            this.deletingBackward = false;
        } else if (delta < 0) {
            delta = -Math.min(-delta, this.cursor);
            System.arraycopy(this.line, this.cursor, this.line, this.cursor + delta, this.size - this.cursor);
            this.size += delta;
            this.cursor += delta;
            this.delta = delta;
            this.deletingBackward = true;
        }
        if (this.delta >= 0) return;
        Arrays.fill(this.line, this.size, this.line.length, 0);
        this.deltaChangedAtEndOfBuffer = this.cursor == this.size;
        this.print(out, width, viMode);
    }

    public void insert(Consumer<int[]> out, String str, int width) {
        this.insert(out, Parser.toCodePoints(str), width);
    }

    void changeCase(Consumer<int[]> out) {
        if (Character.isLetter(this.line[this.cursor])) {
            this.line[this.cursor] = Character.isLowerCase(this.line[this.cursor]) ? Character.toUpperCase(this.line[this.cursor]) : Character.toLowerCase(this.line[this.cursor]);
            out.accept(new int[]{this.line[this.cursor]});
        }
    }

    void upCase(Consumer<int[]> out) {
        if (Character.isLetter(this.line[this.cursor])) {
            this.line[this.cursor] = Character.toUpperCase(this.line[this.cursor]);
            out.accept(new int[]{this.line[this.cursor]});
        }
    }

    void downCase(Consumer<int[]> out) {
        if (Character.isLetter(this.line[this.cursor])) {
            this.line[this.cursor] = Character.toLowerCase(this.line[this.cursor]);
            out.accept(new int[]{this.line[this.cursor]});
        }
    }

    public void replace(Consumer<int[]> out, char rChar) {
        this.doReplace(out, this.cursor(), rChar);
    }

    private void doReplace(Consumer<int[]> out, int pos, int rChar) {
        if (pos > -1 && pos <= this.size) {
            this.line[pos] = rChar;
            out.accept(new int[]{rChar});
        }
    }

    private int[] intToAsciiInts(int value) {
        int length = this.getAsciiSize(value);
        int[] asciiValue = new int[length];
        if (length == 1) {
            asciiValue[0] = 48 + value;
        } else {
            while (length > 0) {
                int num = value % 10;
                asciiValue[--length] = 48 + num;
                value /= 10;
            }
        }
        return asciiValue;
    }

    private int getAsciiSize(int value) {
        if (value < 10) {
            return 1;
        }
        if (value > 9 && value < 99) {
            return 2;
        }
        if (value > 99 && value < 999) {
            return 3;
        }
        if (value > 999 && value < 9999) {
            return 4;
        }
        return 5;
    }
}

