/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.InVmAccess;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.wildfly.security.auth.server.SecurityIdentity;

final class ModelControllerClientFactoryImpl
implements ModelControllerClientFactory {
    private final ModelController modelController;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;

    ModelControllerClientFactoryImpl(ModelController modelController, Supplier<SecurityIdentity> securityIdentitySupplier) {
        this.modelController = modelController;
        this.securityIdentitySupplier = securityIdentitySupplier;
    }

    @Override
    public LocalModelControllerClient createClient(Executor executor) {
        return this.createLocalClient(executor, true);
    }

    @Override
    public LocalModelControllerClient createSuperUserClient(Executor executor, boolean forUserCalls) {
        final LocalClient delegate = this.createLocalClient(executor, forUserCalls);
        return new LocalModelControllerClient(){

            @Override
            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) {
                return (OperationResponse)ModelControllerClientFactoryImpl.executeInVm(delegate::executeOperation, operation, messageHandler);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return (AsyncFuture)ModelControllerClientFactoryImpl.executeInVm(delegate::executeAsync, operation, messageHandler);
            }

            public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return (AsyncFuture)ModelControllerClientFactoryImpl.executeInVm(delegate::executeOperationAsync, operation, messageHandler);
            }

            @Override
            public void close() {
                delegate.close();
            }
        };
    }

    private LocalClient createLocalClient(Executor executor, boolean forUserCalls) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        return new LocalClient(this.modelController, this.securityIdentitySupplier, executor, forUserCalls);
    }

    private static <T, U, R> R executeInVm(BiFunction<T, U, R> function, T t, U u) {
        try {
            return (R)InVmAccess.runInVm(() -> function.apply(t, u));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static interface ResponseConverter<T> {
        public static final ResponseConverter<ModelNode> TO_MODEL_NODE = new ResponseConverter<ModelNode>(){

            @Override
            public ModelNode fromOperationResponse(OperationResponse or) {
                ModelNode result = or.getResponseNode();
                try {
                    or.close();
                }
                catch (IOException e) {
                    ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing %s whose associated streams, if any, were not wanted", or);
                }
                return result;
            }
        };
        public static final ResponseConverter<OperationResponse> TO_OPERATION_RESPONSE = new ResponseConverter<OperationResponse>(){

            @Override
            public OperationResponse fromOperationResponse(OperationResponse or) {
                return or;
            }
        };

        public T fromOperationResponse(OperationResponse var1);
    }

    private static class ResponseFuture<T>
    extends AsyncFutureTask<T> {
        private final AtomicReference<Thread> opThread;
        private final ResponseConverter<T> responseConverter;

        private ResponseFuture(AtomicReference<Thread> opThread, ResponseConverter<T> responseConverter, Executor executor) {
            super(executor);
            this.opThread = opThread;
            this.responseConverter = responseConverter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void asyncCancel(boolean interruptionDesired) {
            Thread thread = this.opThread.getAndSet(Thread.currentThread());
            if (thread == null) {
                this.setCancelled();
            } else {
                thread.interrupt();
                boolean interrupted = false;
                AtomicReference<Thread> atomicReference = this.opThread;
                synchronized (atomicReference) {
                    while (this.opThread.get() != null) {
                        try {
                            this.opThread.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                }
                this.setCancelled();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        void handleResult(OperationResponse result) {
            ModelNode responseNode;
            ModelNode modelNode = responseNode = result == null ? null : result.getResponseNode();
            if (responseNode != null && responseNode.hasDefined("outcome") && "cancelled".equals(responseNode.get("outcome").asString())) {
                this.setCancelled();
            } else {
                this.setResult(this.responseConverter.fromOperationResponse(result));
            }
        }
    }

    private static class LocalClient
    implements LocalModelControllerClient {
        private final ModelController modelController;
        private final Supplier<SecurityIdentity> securityIdentitySupplier;
        private final Executor executor;
        private final boolean forUserCalls;
        private final Set<AtomicReference<Thread>> threads = Collections.synchronizedSet(new HashSet());

        private LocalClient(ModelController modelController, Supplier<SecurityIdentity> securityIdentitySupplier, Executor executor, boolean forUserCalls) {
            this.modelController = modelController;
            this.securityIdentitySupplier = securityIdentitySupplier;
            this.executor = executor;
            this.forUserCalls = forUserCalls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Set<AtomicReference<Thread>> set = this.threads;
            synchronized (set) {
                for (AtomicReference<Thread> threadRef : this.threads) {
                    Thread thread = threadRef.get();
                    if (thread == null) continue;
                    thread.interrupt();
                }
            }
        }

        @Override
        public OperationResponse executeOperation(Operation operation, final OperationMessageHandler messageHandler) {
            OperationResponse response;
            final Operation toExecute = this.sanitizeOperation(operation);
            if (this.forUserCalls) {
                SecurityIdentity securityIdentity = this.securityIdentitySupplier.get();
                response = AccessAuditContext.doAs(securityIdentity, null, new PrivilegedAction<OperationResponse>(){

                    @Override
                    public OperationResponse run() {
                        SecurityActions.currentAccessAuditContext().setAccessMechanism(AccessMechanism.IN_VM_USER);
                        return modelController.execute(toExecute, messageHandler, ModelController.OperationTransactionControl.COMMIT);
                    }
                });
            } else {
                response = this.modelController.execute(toExecute, messageHandler, ModelController.OperationTransactionControl.COMMIT);
            }
            return response;
        }

        public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_MODEL_NODE);
        }

        public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_OPERATION_RESPONSE);
        }

        private <T> AsyncFuture<T> executeAsync(ModelNode op, final OperationMessageHandler messageHandler, final OperationAttachments attachments, ResponseConverter<T> responseConverter) {
            if (this.executor == null) {
                throw ControllerLogger.ROOT_LOGGER.nullAsynchronousExecutor();
            }
            final ModelNode operation = this.sanitizeOperation(op);
            final AtomicReference opThread = new AtomicReference();
            this.threads.add(opThread);
            final ResponseFuture responseFuture = new ResponseFuture(opThread, responseConverter, this.executor);
            final SecurityIdentity securityIdentity = this.securityIdentitySupplier.get();
            final boolean inVmCall = SecurityActions.isInVmCall();
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (opThread.compareAndSet(null, Thread.currentThread())) {
                            OperationResponse response = forUserCalls ? AccessAuditContext.doAs(securityIdentity, null, new PrivilegedAction<OperationResponse>(){

                                @Override
                                public OperationResponse run() {
                                    SecurityActions.currentAccessAuditContext().setAccessMechanism(AccessMechanism.IN_VM_USER);
                                    return this.runOperation(operation, messageHandler, attachments, inVmCall);
                                }
                            }) : this.runOperation(operation, messageHandler, attachments, inVmCall);
                            responseFuture.handleResult(response);
                        }
                    }
                    finally {
                        AtomicReference atomicReference = opThread;
                        synchronized (atomicReference) {
                            opThread.set(null);
                            threads.remove(opThread);
                            opThread.notifyAll();
                        }
                    }
                }
            });
            return responseFuture;
        }

        private Operation sanitizeOperation(Operation operation) {
            ModelNode sanitized = this.sanitizeOperation(operation.getOperation());
            return Operation.Factory.create((ModelNode)sanitized, (List)operation.getInputStreams(), (boolean)operation.isAutoCloseStreams());
        }

        private ModelNode sanitizeOperation(ModelNode operation) {
            ModelNode sanitized = operation.clone();
            if (sanitized.hasDefined("operation-headers")) {
                ModelNode headers = sanitized.get("operation-headers");
                headers.remove("sync-dropped-for-readd");
                headers.remove("domain-uuid");
                headers.remove("execute-for-coordinator");
            }
            if (this.forUserCalls) {
                sanitized.get(new String[]{"operation-headers", "caller-type"}).set("user");
            }
            return sanitized;
        }

        private OperationResponse runOperation(ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments, boolean inVmCall) {
            Operation op;
            Operation operation2 = op = attachments == null ? Operation.Factory.create((ModelNode)operation) : Operation.Factory.create((ModelNode)operation, (List)attachments.getInputStreams(), (boolean)attachments.isAutoCloseStreams());
            if (inVmCall) {
                return SecurityActions.runInVm(() -> this.modelController.execute(op, messageHandler, ModelController.OperationTransactionControl.COMMIT));
            }
            return this.modelController.execute(op, messageHandler, ModelController.OperationTransactionControl.COMMIT);
        }
    }
}

