/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderOrEventDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.ReflectionUtil;

public class AddClientListenerOperation
extends RetryOnFailureOperation<Short>
implements Consumer<ClientEvent> {
    private static final Log log = LogFactory.getLog(AddClientListenerOperation.class, Log.class);
    public final byte[] listenerId;
    private final String cacheNameString;
    private Channel dedicatedChannel;
    private final ClientListenerNotifier listenerNotifier;
    public final Object listener;
    public final byte[][] filterFactoryParams;
    public final byte[][] converterFactoryParams;

    protected AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicInteger topologyId, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        this(codec, channelFactory, cacheName, topologyId, flags, cfg, AddClientListenerOperation.generateListenerId(), listenerNotifier, listener, filterFactoryParams, converterFactoryParams);
    }

    protected AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] listenerId, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super((short)37, (short)38, codec, channelFactory, RemoteCacheManager.cacheNameBytes(cacheName), topologyId, flags, cfg);
        this.listenerId = listenerId;
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
        this.cacheNameString = cacheName;
    }

    public AddClientListenerOperation copy() {
        return new AddClientListenerOperation(this.codec, this.channelFactory, this.cacheNameString, this.header.topologyId(), this.flags, this.cfg, this.listenerId, this.listenerNotifier, this.listener, this.filterFactoryParams, this.converterFactoryParams);
    }

    private static byte[] generateListenerId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] listenerId = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(listenerId);
        bb.putLong(random.nextLong());
        bb.putLong(random.nextLong());
        return listenerId;
    }

    private ClientListener extractClientListener() {
        ClientListener l = (ClientListener)ReflectionUtil.getAnnotation(this.listener.getClass(), ClientListener.class);
        if (l == null) {
            throw log.missingClientListenerAnnotation(this.listener.getClass().getName());
        }
        return l;
    }

    public String getCacheName() {
        return this.cacheNameString;
    }

    public Channel getDedicatedChannel() {
        return this.dedicatedChannel;
    }

    @Override
    protected void executeOperation(Channel channel) {
        CompletableFuture<Void> allCompleteFuture = ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).allCompleteFuture();
        if (allCompleteFuture.isDone()) {
            this.execute(channel);
        } else {
            allCompleteFuture.whenComplete((nil, throwable) -> this.execute(channel));
        }
    }

    private void execute(Channel channel) {
        if (!channel.isActive()) {
            this.channelInactive(channel);
            return;
        }
        ClientListener clientListener = this.extractClientListener();
        channel.pipeline().replace(HeaderDecoder.class, "header-decoder", (ChannelHandler)new HeaderOrEventDecoder(this.codec, this.header, this.channelFactory, this, this, this.listenerId, this.cfg));
        this.scheduleTimeout(channel.eventLoop());
        this.dedicatedChannel = channel;
        this.listenerNotifier.addDispatcher(ClientEventDispatcher.create(this, this.listenerNotifier));
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        this.codec.writeClientListenerParams(buf, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        this.codec.writeClientListenerInterests(buf, ClientEventDispatcher.findMethods(this.listener).keySet());
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            this.listenerNotifier.removeClientListener(this.listenerId);
            throw log.failedToAddListener(this.listener, status);
        }
        this.listenerNotifier.startClientListener(this.listenerId);
        this.complete(status);
    }

    @Override
    public void accept(ClientEvent clientEvent) {
        this.listenerNotifier.invokeEvent(this.listenerId, clientEvent);
    }

    public void postponeTimeout(Channel channel) {
        this.timeoutFuture.cancel(false);
        this.scheduleTimeout(channel.eventLoop());
    }
}

