/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.codec.ByteBufferDecoder;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.SaslFrameHandler;

class SaslFrameParser {
    private SaslFrameHandler _sasl;
    private State _state = State.SIZE_0;
    private int _size;
    private ByteBuffer _buffer;
    private int _ignore = 8;
    private final ByteBufferDecoder _decoder;

    SaslFrameParser(SaslFrameHandler sasl, ByteBufferDecoder decoder) {
        this._sasl = sasl;
        this._decoder = decoder;
    }

    public void input(ByteBuffer input) throws TransportException {
        TransportException frameParsingError = null;
        int size = this._size;
        State state = this._state;
        ByteBuffer oldIn = null;
        if (this._ignore != 0) {
            int bytesToEat = Math.min(this._ignore, input.remaining());
            input.position(input.position() + bytesToEat);
            this._ignore -= bytesToEat;
        }
        while (input.hasRemaining() && state != State.ERROR && !this._sasl.isDone()) {
            switch (state) {
                case SIZE_0: {
                    if (input.remaining() >= 4) {
                        size = input.getInt();
                        state = State.PRE_PARSE;
                        break;
                    }
                    size = input.get() << 24 & 0xFF000000;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    size |= input.get() << 16 & 0xFF0000;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    size |= input.get() << 8 & 0xFF00;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    size |= input.get() & 0xFF;
                    state = State.PRE_PARSE;
                }
                case PRE_PARSE: {
                    if (size < 8) {
                        frameParsingError = new TransportException("specified frame size %d smaller than minimum frame header size %d", this._size, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (input.remaining() < size - 4) {
                        this._buffer = ByteBuffer.allocate(size - 4);
                        this._buffer.put(input);
                        state = State.BUFFERING;
                        break;
                    }
                }
                case BUFFERING: {
                    if (this._buffer != null) {
                        if (input.remaining() < this._buffer.remaining()) {
                            this._buffer.put(input);
                            break;
                        }
                        ByteBuffer dup = input.duplicate();
                        dup.limit(dup.position() + this._buffer.remaining());
                        input.position(input.position() + this._buffer.remaining());
                        this._buffer.put(dup);
                        oldIn = input;
                        this._buffer.flip();
                        input = this._buffer;
                        state = State.PARSING;
                    }
                }
                case PARSING: {
                    int dataOffset = input.get() << 2 & 0x3FF;
                    if (dataOffset < 8) {
                        frameParsingError = new TransportException("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset > size) {
                        frameParsingError = new TransportException("specified frame data offset %d larger than the frame size %d", dataOffset, this._size);
                        state = State.ERROR;
                        break;
                    }
                    int type = input.get() & 0xFF;
                    input.get();
                    input.get();
                    if (type != 1) {
                        frameParsingError = new TransportException("unknown frame type: %d", type);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset != 8) {
                        input.position(input.position() + dataOffset - 8);
                    }
                    if (oldIn == null) {
                        oldIn = input;
                        input = input.duplicate();
                        int endPos = input.position() + size - dataOffset;
                        input.limit(endPos);
                        oldIn.position(endPos);
                    }
                    try {
                        Binary payload;
                        this._decoder.setByteBuffer(input);
                        Object val = this._decoder.readObject();
                        if (input.hasRemaining()) {
                            byte[] payloadBytes = new byte[input.remaining()];
                            input.get(payloadBytes);
                            payload = new Binary(payloadBytes);
                        } else {
                            payload = null;
                        }
                        if (val instanceof SaslFrameBody) {
                            SaslFrameBody frameBody = (SaslFrameBody)val;
                            this._sasl.handle(frameBody, payload);
                            this.reset();
                            input = oldIn;
                            oldIn = null;
                            this._buffer = null;
                            state = State.SIZE_0;
                            break;
                        }
                        state = State.ERROR;
                        frameParsingError = new TransportException("Unexpected frame type encountered. Found a %s which does not implement %s", val == null ? "null" : val.getClass(), SaslFrameBody.class);
                    }
                    catch (DecodeException ex) {
                        state = State.ERROR;
                        frameParsingError = new TransportException(ex);
                    }
                    break;
                }
            }
        }
        this._state = state;
        this._size = size;
        if (this._state == State.ERROR) {
            if (frameParsingError != null) {
                throw frameParsingError;
            }
            throw new TransportException("Unable to parse, probably because of a previous error");
        }
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    static enum State {
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

