/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logging;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;

public class LoggingLogger_$logger
extends DelegatingBasicLogger
implements LoggingLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String failedToCloseResource = "WFLYLOG0006: Failed to close resource %s";
    private static final String invalidPropertyAttribute = "WFLYLOG0007: The attribute %s could not be set as it is not a configurable property value.";
    private static final String pathManagerServiceNotStarted = "WFLYLOG0008: The path manager service does not appear to be started. Any changes may be lost as a result of this.";
    private static final String loggingProfileNotFound = "WFLYLOG0010: Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.";
    private static final String julConfigurationFileFound = "WFLYLOG0011: The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.";
    private static final String replacingNamedHandler = "WFLYLOG0012: Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.";
    private static final String replacingConfigurator = "WFLYLOG0013: A configurator class, '%s', is not a known configurator and will be replaced.";
    private static final String logContextNotRemoved = "WFLYLOG0014: The log context (%s) could not be removed for deployment %s";
    private static final String perDeploymentPropertyDeprecated = "WFLYLOG0015: The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.";
    private static final String perLoggingDeploymentIgnored = "WFLYLOG0016: The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.";
    private static final String cannotLoadModule = "WFLYLOG0019: Failed to load module '%s' for %s '%s'";
    private static final String classNotFound = "WFLYLOG0021: Class '%s' could not be found.";
    private static final String handlerAlreadyDefined = "WFLYLOG0023: Handler %s is already assigned.";
    private static final String invalidFilter = "WFLYLOG0025: Filter %s is invalid";
    private static final String invalidLogLevel = "WFLYLOG0026: Log level %s is invalid.";
    private static final String invalidOverflowAction = "WFLYLOG0027: Overflow action %s is invalid.";
    private static final String invalidSize = "WFLYLOG0028: Invalid size %s";
    private static final String loggerNotFound = "WFLYLOG0035: Logger '%s' was not found.";
    private static final String invalidRelativeTo = "WFLYLOG0039: An absolute path (%s) cannot be specified for relative-to.";
    private static final String invalidSuffix = "WFLYLOG0041: The suffix (%s) is invalid. A suffix must be a valid date format.";
    private static final String failedToConfigureLogging = "WFLYLOG0042: Failed to configure logging using '%s' configuration file.";
    private static final String errorProcessingLoggingConfiguration = "WFLYLOG0043: Error occurred while searching for logging configuration files.";
    private static final String handlerAttachedToHandlers = "WFLYLOG0044: Handler %s is attached to the following handlers and cannot be removed; %s";
    private static final String handlerAttachedToLoggers = "WFLYLOG0045: Handler %s is attached to the following loggers and cannot be removed; %s";
    private static final String cannotAddHandlerToSelf = "WFLYLOG0046: Cannot add handler (%s) to itself";
    private static final String handlerClosed = "WFLYLOG0047: The handler is closed, cannot publish to a closed handler";
    private static final String handlerConfigurationNotFound = "WFLYLOG0048: Configuration for handler '%s' could not be found.";
    private static final String loggerConfigurationNotFound = "WFLYLOG0049: Configuration for logger '%s' could not be found.";
    private static final String unsupportedMethod = "WFLYLOG0050: Method %s on class %s is not supported";
    private static final String failedToWriteConfigurationFile = "WFLYLOG0051: Failed to write configuration file %s";
    private static final String formatterNotFound = "WFLYLOG0061: Formatter '%s' is not found";
    private static final String truncatedFilterExpression = "WFLYLOG0070: Truncated filter expression string";
    private static final String invalidEscapeFoundInFilterExpression = "WFLYLOG0071: Invalid escape found in filter expression string";
    private static final String filterNotFound = "WFLYLOG0072: Filter '%s' is not found";
    private static final String expectedIdentifier = "WFLYLOG0073: Expected identifier next in filter expression";
    private static final String expectedString = "WFLYLOG0074: Expected string next in filter expression";
    private static final String expected1 = "WFLYLOG0075: Expected '%s' next in filter expression";
    private static final String expected2 = "WFLYLOG0075: Expected '%s' or '%s' next in filter expression";
    private static final String unexpectedEnd = "WFLYLOG0076: Unexpected end of filter expression";
    private static final String extensionNotInitialized = "WFLYLOG0078: The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"";
    private static final String failedToReadLogFile = "WFLYLOG0079: Failed to read the log file '%s'";
    private static final String logFileNotFound = "WFLYLOG0080: File '%s' was not found and cannot be found in the %s directory.";
    private static final String readNotAllowed = "WFLYLOG0081: File '%s' is not allowed to be read.";
    private static final String suffixContainsMillis = "WFLYLOG0082: The suffix (%s) can not contain seconds or milliseconds.";
    private static final String invalidLogFile = "WFLYLOG0083: Path '%s' is a directory and cannot be used as a log file.";
    private static final String cannotRegisterResourceOfType = "WFLYLOG0084: Resources of type %s cannot be registered";
    private static final String cannotRemoveResourceOfType = "WFLYLOG0085: Resources of type %s cannot be removed";
    private static final String deploymentNameNotFound = "WFLYLOG0086: Could not determine deployment name from the address %s.";
    private static final String errorProcessingLogDirectory = "WFLYLOG0087: Failed to process logging directory %s. Log files cannot be listed.";
    private static final String errorDeterminingChildrenExist = "WFLYLOG0088: Could not determine %s had any children resources.";
    private static final String unknownLogManager = "WFLYLOG0089: The log manager check was skipped and the log manager system property, \"java.util.logging.manager\", does not appear to be set to \"org.jboss.logmanager.LogManager\". The current value is \"%s\". Some behavior of the logged output such as MDC and NDC may not work as expected.";
    private static final String unresolvablePathExpressions = "WFLYLOG0090: The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s";
    private static final AtomicBoolean unresolvablePathExpressions_$Once = new AtomicBoolean(false);
    private static final String invalidExceptionOutputType = "WFLYLOG0091: Exception output type %s is invalid.";

    public LoggingLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToCloseResource(Throwable cause, Closeable closeable) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), (Object)closeable);
    }

    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }

    @Override
    public final void invalidPropertyAttribute(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidPropertyAttribute$str(), (Object)name);
    }

    protected String invalidPropertyAttribute$str() {
        return invalidPropertyAttribute;
    }

    protected String pathManagerServiceNotStarted$str() {
        return pathManagerServiceNotStarted;
    }

    @Override
    public final String pathManagerServiceNotStarted() {
        return String.format(this.getLoggingLocale(), this.pathManagerServiceNotStarted$str(), new Object[0]);
    }

    @Override
    public final void loggingProfileNotFound(String loggingProfile, ResourceRoot deployment) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.loggingProfileNotFound$str(), (Object)loggingProfile, (Object)deployment);
    }

    protected String loggingProfileNotFound$str() {
        return loggingProfileNotFound;
    }

    @Override
    public final void julConfigurationFileFound(String fileName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.julConfigurationFileFound$str(), (Object)fileName);
    }

    protected String julConfigurationFileFound$str() {
        return julConfigurationFileFound;
    }

    @Override
    public final void replacingNamedHandler(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.replacingNamedHandler$str(), (Object)name);
    }

    protected String replacingNamedHandler$str() {
        return replacingNamedHandler;
    }

    @Override
    public final void replacingConfigurator(Configurator c) {
        if (this.log.isEnabled(Logger.Level.WARN)) {
            Class<?> cClass = c == null ? null : c.getClass();
            this.log.logf(FQCN, Logger.Level.WARN, null, this.replacingConfigurator$str(), cClass);
        }
    }

    protected String replacingConfigurator$str() {
        return replacingConfigurator;
    }

    @Override
    public final void logContextNotRemoved(LogContext logContext, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.logContextNotRemoved$str(), (Object)logContext, (Object)deploymentName);
    }

    protected String logContextNotRemoved$str() {
        return logContextNotRemoved;
    }

    @Override
    public final void perDeploymentPropertyDeprecated(String propertyName, String attributeName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.perDeploymentPropertyDeprecated$str(), (Object)propertyName, (Object)attributeName);
    }

    protected String perDeploymentPropertyDeprecated$str() {
        return perDeploymentPropertyDeprecated;
    }

    @Override
    public final void perLoggingDeploymentIgnored(String propertyName, String attributeName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.perLoggingDeploymentIgnored$str(), (Object)propertyName, (Object)attributeName, (Object)deploymentName);
    }

    protected String perLoggingDeploymentIgnored$str() {
        return perLoggingDeploymentIgnored;
    }

    protected String cannotLoadModule$str() {
        return cannotLoadModule;
    }

    @Override
    public final IllegalArgumentException cannotLoadModule(Throwable cause, String moduleName, String description, String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotLoadModule$str(), moduleName, description, name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String classNotFound$str() {
        return classNotFound;
    }

    @Override
    public final String classNotFound(Throwable cause, String className) {
        return String.format(this.getLoggingLocale(), this.classNotFound$str(), className);
    }

    protected String handlerAlreadyDefined$str() {
        return handlerAlreadyDefined;
    }

    @Override
    public final String handlerAlreadyDefined(String name) {
        return String.format(this.getLoggingLocale(), this.handlerAlreadyDefined$str(), name);
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final String invalidFilter(String name) {
        return String.format(this.getLoggingLocale(), this.invalidFilter$str(), name);
    }

    protected String invalidLogLevel$str() {
        return invalidLogLevel;
    }

    @Override
    public final String invalidLogLevel(String level) {
        return String.format(this.getLoggingLocale(), this.invalidLogLevel$str(), level);
    }

    protected String invalidOverflowAction$str() {
        return invalidOverflowAction;
    }

    @Override
    public final String invalidOverflowAction(String overflowAction) {
        return String.format(this.getLoggingLocale(), this.invalidOverflowAction$str(), overflowAction);
    }

    protected String invalidSize$str() {
        return invalidSize;
    }

    @Override
    public final String invalidSize(String size) {
        return String.format(this.getLoggingLocale(), this.invalidSize$str(), size);
    }

    protected String loggerNotFound$str() {
        return loggerNotFound;
    }

    @Override
    public final String loggerNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.loggerNotFound$str(), name);
    }

    protected String invalidRelativeTo$str() {
        return invalidRelativeTo;
    }

    @Override
    public final String invalidRelativeTo(String relativeTo) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeTo$str(), relativeTo);
    }

    protected String invalidSuffix$str() {
        return invalidSuffix;
    }

    @Override
    public final String invalidSuffix(String suffix) {
        return String.format(this.getLoggingLocale(), this.invalidSuffix$str(), suffix);
    }

    protected String failedToConfigureLogging$str() {
        return failedToConfigureLogging;
    }

    @Override
    public final DeploymentUnitProcessingException failedToConfigureLogging(Throwable cause, String fileName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToConfigureLogging$str(), fileName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorProcessingLoggingConfiguration$str() {
        return errorProcessingLoggingConfiguration;
    }

    @Override
    public final DeploymentUnitProcessingException errorProcessingLoggingConfiguration(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorProcessingLoggingConfiguration$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerAttachedToHandlers$str() {
        return handlerAttachedToHandlers;
    }

    @Override
    public final OperationFailedException handlerAttachedToHandlers(String handlerName, Collection<String> handlers) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.handlerAttachedToHandlers$str(), handlerName, handlers));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerAttachedToLoggers$str() {
        return handlerAttachedToLoggers;
    }

    @Override
    public final OperationFailedException handlerAttachedToLoggers(String handlerName, Collection<String> loggers) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.handlerAttachedToLoggers$str(), handlerName, loggers));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddHandlerToSelf$str() {
        return cannotAddHandlerToSelf;
    }

    @Override
    public final String cannotAddHandlerToSelf(String handlerName) {
        return String.format(this.getLoggingLocale(), this.cannotAddHandlerToSelf$str(), handlerName);
    }

    protected String handlerClosed$str() {
        return handlerClosed;
    }

    @Override
    public final IllegalStateException handlerClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.handlerClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerConfigurationNotFound$str() {
        return handlerConfigurationNotFound;
    }

    @Override
    public final String handlerConfigurationNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.handlerConfigurationNotFound$str(), name);
    }

    protected String loggerConfigurationNotFound$str() {
        return loggerConfigurationNotFound;
    }

    @Override
    public final String loggerConfigurationNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.loggerConfigurationNotFound$str(), name);
    }

    protected String unsupportedMethod$str() {
        return unsupportedMethod;
    }

    @Override
    public final UnsupportedOperationException unsupportedMethod(String methodName, String className) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedMethod$str(), methodName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToWriteConfigurationFile$str() {
        return failedToWriteConfigurationFile;
    }

    @Override
    public final RuntimeException failedToWriteConfigurationFile(Throwable e, File fileName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToWriteConfigurationFile$str(), fileName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String formatterNotFound$str() {
        return formatterNotFound;
    }

    @Override
    public final String formatterNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.formatterNotFound$str(), name);
    }

    protected String truncatedFilterExpression$str() {
        return truncatedFilterExpression;
    }

    @Override
    public final IllegalArgumentException truncatedFilterExpression() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.truncatedFilterExpression$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidEscapeFoundInFilterExpression$str() {
        return invalidEscapeFoundInFilterExpression;
    }

    @Override
    public final IllegalArgumentException invalidEscapeFoundInFilterExpression() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidEscapeFoundInFilterExpression$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filterNotFound$str() {
        return filterNotFound;
    }

    @Override
    public final IllegalArgumentException filterNotFound(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.filterNotFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedIdentifier$str() {
        return expectedIdentifier;
    }

    @Override
    public final IllegalArgumentException expectedIdentifier() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedIdentifier$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedString$str() {
        return expectedString;
    }

    @Override
    public final IllegalArgumentException expectedString() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expected1$str() {
        return expected1;
    }

    @Override
    public final IllegalArgumentException expected(String token) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expected1$str(), token));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expected2$str() {
        return expected2;
    }

    @Override
    public final IllegalArgumentException expected(String trueToken, String falseToken) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expected2$str(), trueToken, falseToken));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedEnd$str() {
        return unexpectedEnd;
    }

    @Override
    public final IllegalArgumentException unexpectedEnd() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedEnd$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionNotInitialized$str() {
        return extensionNotInitialized;
    }

    @Override
    public final IllegalStateException extensionNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.extensionNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToReadLogFile$str() {
        return failedToReadLogFile;
    }

    @Override
    public final RuntimeException failedToReadLogFile(Throwable cause, String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToReadLogFile$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String logFileNotFound$str() {
        return logFileNotFound;
    }

    @Override
    public final Resource.NoSuchResourceException logFileNotFound(String name, String directoryProperty) {
        Resource.NoSuchResourceException result = new Resource.NoSuchResourceException(String.format(this.getLoggingLocale(), this.logFileNotFound$str(), name, directoryProperty));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readNotAllowed$str() {
        return readNotAllowed;
    }

    @Override
    public final OperationFailedException readNotAllowed(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.readNotAllowed$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }

    @Override
    public final String suffixContainsMillis(String suffix) {
        return String.format(this.getLoggingLocale(), this.suffixContainsMillis$str(), suffix);
    }

    protected String invalidLogFile$str() {
        return invalidLogFile;
    }

    @Override
    public final OperationFailedException invalidLogFile(String path) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidLogFile$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRegisterResourceOfType$str() {
        return cannotRegisterResourceOfType;
    }

    @Override
    public final UnsupportedOperationException cannotRegisterResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotRegisterResourceOfType$str(), childType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }

    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotRemoveResourceOfType$str(), childType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deploymentNameNotFound$str() {
        return deploymentNameNotFound;
    }

    @Override
    public final IllegalArgumentException deploymentNameNotFound(PathAddress address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.deploymentNameNotFound$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void errorProcessingLogDirectory(String logDir) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorProcessingLogDirectory$str(), (Object)logDir);
    }

    protected String errorProcessingLogDirectory$str() {
        return errorProcessingLogDirectory;
    }

    @Override
    public final void errorDeterminingChildrenExist(Throwable cause, String childType) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorDeterminingChildrenExist$str(), (Object)childType);
    }

    protected String errorDeterminingChildrenExist$str() {
        return errorDeterminingChildrenExist;
    }

    @Override
    public final void unknownLogManager(String logManagerName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownLogManager$str(), (Object)logManagerName);
    }

    protected String unknownLogManager$str() {
        return unknownLogManager;
    }

    @Override
    public final void unresolvablePathExpressions(Set<String> unresolvableExpressions) {
        if (this.log.isEnabled(Logger.Level.WARN) && unresolvablePathExpressions_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.unresolvablePathExpressions$str(), unresolvableExpressions);
        }
    }

    protected String unresolvablePathExpressions$str() {
        return unresolvablePathExpressions;
    }

    protected String invalidExceptionOutputType$str() {
        return invalidExceptionOutputType;
    }

    @Override
    public final OperationFailedException invalidExceptionOutputType(String value) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidExceptionOutputType$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

