/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.DistributedCacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorServiceConfigurator;
import org.wildfly.clustering.web.infinispan.session.RouteRegistryEntryProviderBuilder;
import org.wildfly.clustering.web.session.RouteLocatorServiceConfiguratorProvider;

public class InfinispanRouteLocatorServiceConfiguratorProvider
implements RouteLocatorServiceConfiguratorProvider,
Consumer<ConfigurationBuilder> {
    public CapabilityServiceConfigurator getRouteLocatorServiceConfigurator(String serverName, String deploymentName) {
        return new InfinispanRouteLocatorServiceConfigurator(serverName, deploymentName);
    }

    public Collection<CapabilityServiceConfigurator> getRouteLocatorConfigurationServiceConfigurators(String serverName, SupplierDependency<String> routeDependency) {
        String containerName = "web";
        LinkedList<CapabilityServiceConfigurator> builders = new LinkedList<CapabilityServiceConfigurator>();
        builders.add(new RouteRegistryEntryProviderBuilder(serverName, routeDependency));
        builders.add((CapabilityServiceConfigurator)new TemplateConfigurationServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, serverName)), containerName, serverName, null, (Consumer)this));
        builders.add((CapabilityServiceConfigurator)new CacheServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, serverName)), containerName, serverName));
        ServiceNameRegistry registry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, serverName));
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(DistributedCacheServiceConfiguratorProvider.class, DistributedCacheServiceConfiguratorProvider.class.getClassLoader())) {
            builders.addAll(cacheServiceConfiguratorProvider.getServiceConfigurators(registry, containerName, serverName));
        }
        return builders;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        ClusteringConfigurationBuilder clustering;
        CacheMode mode = (clustering = builder.clustering()).cacheMode();
        clustering.cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        clustering.hash().consistentHashFactory(null);
        clustering.l1().disable();
        AttributeSet attributes = TemplateConfigurationServiceConfigurator.getAttributes((ConfigurationChildBuilder)clustering);
        attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).reset();
        attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).reset();
        attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).reset();
        builder.dataContainer().dataContainer(null);
        builder.expiration().lifespan(-1L).maxIdle(-1L);
        builder.memory().size(-1L).evictionStrategy(EvictionStrategy.MANUAL);
        builder.persistence().clearStores();
    }
}

