/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.jpa.event.internal.AbstractCallback;
import org.hibernate.jpa.event.internal.EmbeddableCallback;
import org.hibernate.jpa.event.internal.EntityCallback;
import org.hibernate.jpa.event.internal.ListenerCallback;
import org.hibernate.jpa.event.spi.Callback;
import org.hibernate.jpa.event.spi.CallbackBuilder;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.jboss.logging.Logger;

public class CallbackBuilderLegacyImpl
implements CallbackBuilder {
    private static final Logger log = Logger.getLogger(CallbackBuilderLegacyImpl.class);
    private final ManagedBeanRegistry managedBeanRegistry;
    private final ReflectionManager reflectionManager;
    private static boolean useAnnotationAnnotatedByListener = false;

    public CallbackBuilderLegacyImpl(ManagedBeanRegistry managedBeanRegistry, ReflectionManager reflectionManager) {
        this.managedBeanRegistry = managedBeanRegistry;
        this.reflectionManager = reflectionManager;
    }

    @Override
    public void buildCallbacksForEntity(String entityClassName, CallbackBuilder.CallbackRegistrar callbackRegistrar) {
        boolean debugEnabled = log.isDebugEnabled();
        try {
            XClass entityXClass = this.reflectionManager.classForName(entityClassName);
            Class entityClass = this.reflectionManager.toClass(entityXClass);
            for (CallbackType callbackType : CallbackType.values()) {
                if (callbackRegistrar.hasRegisteredCallbacks(entityClass, callbackType)) {
                    if (!debugEnabled) continue;
                    log.debugf("CallbackRegistry reported that Class [%s] already had %s callbacks registered; assuming this means the class was mapped twice (using hbm.xml entity-name support) - skipping subsequent registrations", (Object)entityClassName, (Object)callbackType.getCallbackAnnotation().getSimpleName());
                    continue;
                }
                Callback[] callbacks = this.resolveEntityCallbacks(entityXClass, callbackType, this.reflectionManager);
                callbackRegistrar.registerCallbacks(entityClass, callbacks);
            }
        }
        catch (ClassLoadingException e) {
            throw new MappingException("entity class not found: " + entityClassName, e);
        }
    }

    @Override
    public void buildCallbacksForEmbeddable(Property embeddableProperty, String entityClassName, CallbackBuilder.CallbackRegistrar callbackRegistrar) {
        try {
            XClass entityXClass = this.reflectionManager.classForName(entityClassName);
            Class entityClass = this.reflectionManager.toClass(entityXClass);
            for (CallbackType callbackType : CallbackType.values()) {
                Callback[] callbacks = this.resolveEmbeddableCallbacks(entityClass, embeddableProperty, callbackType, this.reflectionManager);
                callbackRegistrar.registerCallbacks(entityClass, callbacks);
            }
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Class not found: ", e);
        }
    }

    @Override
    public void release() {
    }

    public Callback[] resolveEntityCallbacks(XClass beanClass, CallbackType callbackType, ReflectionManager reflectionManager) {
        List defaultListeners;
        ArrayList<AbstractCallback> callbacks = new ArrayList<AbstractCallback>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<Class> orderedListeners = new ArrayList<Class>();
        XClass currentClazz = beanClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        boolean debugEnabled = log.isDebugEnabled();
        do {
            EntityCallback callback = null;
            List<XMethod> methods = CallbackBuilderLegacyImpl.getDeclaredMethods(currentClazz);
            for (XMethod xMethod : methods) {
                Method method;
                String methodName;
                if (!xMethod.isAnnotationPresent(callbackType.getCallbackAnnotation()) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new EntityCallback(method, callbackType);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackType.getCallbackAnnotation().getName() + " - " + xMethod);
                    }
                    ReflectHelper.ensureAccessibility(method);
                    if (debugEnabled) {
                        log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)beanClass.getName());
                    }
                    callbacks.add(0, callback);
                    callbacksMethodNames.add(0, methodName);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + beanClass.getName());
            }
            if (!stopListeners) {
                CallbackBuilderLegacyImpl.getListeners(currentClazz, orderedListeners);
                stopListeners = currentClazz.isAnnotationPresent(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.isAnnotationPresent(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperclass()) != null && !currentClazz.isAnnotationPresent(Entity.class) && !currentClazz.isAnnotationPresent(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && (defaultListeners = (List)reflectionManager.getDefaults().get(EntityListeners.class)) != null) {
            int defaultListenerSize = defaultListeners.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add((Class)defaultListeners.get(i));
            }
        }
        for (Class listener : orderedListeners) {
            ListenerCallback callback = null;
            if (listener == null) continue;
            XClass xListener = reflectionManager.toXClass(listener);
            callbacksMethodNames = new ArrayList();
            List<XMethod> methods = CallbackBuilderLegacyImpl.getDeclaredMethods(xListener);
            for (XMethod xMethod : methods) {
                Method method;
                String methodName;
                if (!xMethod.isAnnotationPresent(callbackType.getCallbackAnnotation()) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new ListenerCallback(this.managedBeanRegistry.getBean(listener), method, callbackType);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + callbackType.getCallbackAnnotation().getName() + " - " + method);
                    }
                    ReflectHelper.ensureAccessibility(method);
                    if (debugEnabled) {
                        log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)beanClass.getName());
                    }
                    callbacks.add(0, callback);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + beanClass.getName() + " and callback listener: " + listener.getName());
            }
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    public Callback[] resolveEmbeddableCallbacks(Class entityClass, Property embeddableProperty, CallbackType callbackType, ReflectionManager reflectionManager) {
        String embeddableClassName = embeddableProperty.getType().getReturnedClass().getName();
        XClass embeddableXClass = reflectionManager.classForName(embeddableClassName);
        Getter embeddableGetter = embeddableProperty.getGetter(entityClass);
        boolean debugEnabled = log.isDebugEnabled();
        ArrayList<EmbeddableCallback> callbacks = new ArrayList<EmbeddableCallback>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        XClass currentClazz = embeddableXClass;
        do {
            EmbeddableCallback callback = null;
            List methods = currentClazz.getDeclaredMethods();
            for (XMethod xMethod : methods) {
                Method method;
                String methodName;
                if (!xMethod.isAnnotationPresent(callbackType.getCallbackAnnotation()) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new EmbeddableCallback(embeddableGetter, method, callbackType);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackType.getCallbackAnnotation().getName() + " - " + xMethod);
                    }
                    ReflectHelper.ensureAccessibility(method);
                    if (debugEnabled) {
                        log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)embeddableXClass.getName());
                    }
                    callbacks.add(0, callback);
                    callbacksMethodNames.add(0, methodName);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + embeddableXClass.getName());
            }
            while ((currentClazz = currentClazz.getSuperclass()) != null && !currentClazz.isAnnotationPresent(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    private static void getListeners(XClass currentClazz, List<Class> orderedListeners) {
        EntityListeners entityListeners = (EntityListeners)currentClazz.getAnnotation(EntityListeners.class);
        if (entityListeners != null) {
            Class[] classes = entityListeners.value();
            int size = classes.length;
            for (int index = size - 1; index >= 0; --index) {
                orderedListeners.add(classes[index]);
            }
        }
        if (useAnnotationAnnotatedByListener) {
            Annotation[] annotations;
            for (Annotation annot : annotations = currentClazz.getAnnotations()) {
                entityListeners = annot.getClass().getAnnotation(EntityListeners.class);
                if (entityListeners == null) continue;
                Class[] classes = entityListeners.value();
                int size = classes.length;
                for (int index = size - 1; index >= 0; --index) {
                    orderedListeners.add(classes[index]);
                }
            }
        }
    }

    private static List<XMethod> getDeclaredMethods(final XClass clazz) {
        PrivilegedAction<List<XMethod>> action = new PrivilegedAction<List<XMethod>>(){

            @Override
            public List<XMethod> run() {
                return clazz.getDeclaredMethods();
            }
        };
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : (List)action.run();
    }

    static {
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
            }
        }
    }
}

