/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import io.smallrye.opentracing.SmallRyeTracingDynamicFeature;
import java.util.ArrayList;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.wildfly.extension.microprofile.opentracing.TracingExtensionLogger;
import org.wildfly.microprofile.opentracing.smallrye.TracerInitializer;
import org.wildfly.microprofile.opentracing.smallrye.TracingCDIExtension;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TracingDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext deploymentPhaseContext) {
        TracingExtensionLogger.ROOT_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            TracingExtensionLogger.ROOT_LOGGER.noCdiDeployment();
            return;
        }
        this.addListeners(deploymentUnit);
        this.addJaxRsIntegration(deploymentUnit);
        this.addCDIExtension(deploymentUnit);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private void addListeners(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData) {
            return;
        }
        TracingExtensionLogger.ROOT_LOGGER.registeringTracerInitializer();
        String serviceName = this.getServiceName(deploymentUnit);
        ParamValueMetaData serviceNameContextParameter = new ParamValueMetaData();
        serviceNameContextParameter.setParamName("smallrye.opentracing.serviceName");
        serviceNameContextParameter.setParamValue(serviceName);
        this.addContextParameter(jbossWebMetaData, serviceNameContextParameter);
        ListenerMetaData listenerMetaData = new ListenerMetaData();
        listenerMetaData.setListenerClass(TracerInitializer.class.getName());
        ArrayList<ListenerMetaData> listeners = jbossWebMetaData.getListeners();
        if (null == listeners) {
            listeners = new ArrayList<ListenerMetaData>();
        }
        listeners.add(listenerMetaData);
        jbossWebMetaData.setListeners(listeners);
    }

    private void addJaxRsIntegration(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData) {
            return;
        }
        TracingExtensionLogger.ROOT_LOGGER.registeringJaxRs();
        ParamValueMetaData restEasyProvider = new ParamValueMetaData();
        restEasyProvider.setParamName("resteasy.providers");
        restEasyProvider.setParamValue(SmallRyeTracingDynamicFeature.class.getName());
        this.addContextParameter(jbossWebMetaData, restEasyProvider);
    }

    private void addCDIExtension(DeploymentUnit deploymentUnit) {
        TracingExtensionLogger.ROOT_LOGGER.registeringCDIExtension();
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
        extensions.registerExtensionInstance((Extension)new TracingCDIExtension(), deploymentUnit);
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (null == warMetaData) {
            return null;
        }
        return warMetaData.getMergedJBossWebMetaData();
    }

    private void addContextParameter(JBossWebMetaData jbossWebMetaData, ParamValueMetaData restEasyProvider) {
        ArrayList<ParamValueMetaData> contextParams = jbossWebMetaData.getContextParams();
        if (null == contextParams) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        contextParams.add(restEasyProvider);
        jbossWebMetaData.setContextParams(contextParams);
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        String serviceName = WildFlySecurityManager.getPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        if (null == serviceName || serviceName.isEmpty()) {
            serviceName = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        }
        if (null == serviceName || serviceName.isEmpty()) {
            TracingExtensionLogger.ROOT_LOGGER.serviceNameDerivedFromDeploymentUnit(serviceName);
            serviceName = deploymentUnit.getServiceName().getSimpleName();
        }
        return serviceName;
    }
}

