/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public abstract class AbstractArraySerializer<T>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    protected final JsonBindingModel containerModel;
    protected final Type arrayValType = this.resolveArrayType();

    protected AbstractArraySerializer(SerializerBuilder builder) {
        super(builder);
        this.containerModel = new ContainerModel(this.arrayValType, this.resolveContainerModelCustomization(this.arrayValType, builder.getJsonbContext()));
    }

    private Type resolveArrayType() {
        if (this.getRuntimeType() == null || this.getRuntimeType() == Object.class) {
            return Object.class;
        }
        if (this.getRuntimeType() instanceof ParameterizedType) {
            return ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]);
        }
        if (this.getRuntimeType() instanceof GenericArrayType) {
            return ReflectionUtils.resolveRawType(this, ((GenericArrayType)this.getRuntimeType()).getGenericComponentType());
        }
        return ReflectionUtils.getRawType(this.getRuntimeType()).getComponentType();
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartArray(key);
    }
}

