/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.security.AccessController;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.Password;

public final class SubjectUtil {
    public static Subject fromSecurityIdentity(SecurityIdentity securityIdentity) {
        return SubjectUtil.fromSecurityIdentity(securityIdentity, new Subject());
    }

    public static Subject fromSecurityIdentity(SecurityIdentity securityIdentity, Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        subject.getPrincipals().add(securityIdentity.getPrincipal());
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        for (String role : securityIdentity.getRoles()) {
            rolesGroup.addMember((Principal)new NamePrincipal(role));
        }
        subject.getPrincipals().add((Principal)((Object)rolesGroup));
        SimpleGroup callerPrincipalGroup = new SimpleGroup("CallerPrincipal");
        callerPrincipalGroup.addMember(securityIdentity.getPrincipal());
        subject.getPrincipals().add((Principal)((Object)callerPrincipalGroup));
        for (Credential credential : securityIdentity.getPublicCredentials()) {
            if (credential instanceof PublicKeyCredential) {
                subject.getPublicCredentials().add(((PublicKeyCredential)credential.castAs(PublicKeyCredential.class)).getPublicKey());
                continue;
            }
            if (credential instanceof X509CertificateChainPublicCredential) {
                subject.getPublicCredentials().add(((X509CertificateChainPublicCredential)credential.castAs(X509CertificateChainPublicCredential.class)).getCertificateChain());
                continue;
            }
            subject.getPublicCredentials().add(credential);
        }
        for (Credential credential : securityIdentity.getPrivateCredentials()) {
            if (credential instanceof PasswordCredential) {
                SubjectUtil.addPrivateCredential(subject, ((PasswordCredential)credential.castAs(PasswordCredential.class)).getPassword());
                continue;
            }
            if (credential instanceof SecretKeyCredential) {
                SubjectUtil.addPrivateCredential(subject, ((SecretKeyCredential)credential.castAs(SecretKeyCredential.class)).getSecretKey());
                continue;
            }
            if (credential instanceof KeyPairCredential) {
                SubjectUtil.addPrivateCredential(subject, ((KeyPairCredential)credential.castAs(KeyPairCredential.class)).getKeyPair());
                continue;
            }
            if (credential instanceof X509CertificateChainPrivateCredential) {
                SubjectUtil.addPrivateCredential(subject, ((X509CertificateChainPrivateCredential)credential.castAs(X509CertificateChainPrivateCredential.class)).getCertificateChain());
                continue;
            }
            SubjectUtil.addPrivateCredential(subject, credential);
        }
        SubjectUtil.addPrivateCredential(subject, securityIdentity);
        return subject;
    }

    private static void addPrivateCredential(Subject subject, Object credential) {
        if (!WildFlySecurityManager.isChecking()) {
            subject.getPrivateCredentials().add(credential);
        } else {
            AccessController.doPrivileged(() -> {
                subject.getPrivateCredentials().add(credential);
                return null;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SecurityIdentity convertToSecurityIdentity(Subject subject, Principal principal, SecurityDomain domain, String roleCategory) {
        void var7_10;
        SecurityIdentity identity = domain.createAdHocIdentity(principal);
        HashSet<String> roles = new HashSet<String>();
        for (Principal principal2 : subject.getPrincipals()) {
            if (!(principal2 instanceof Group) || !"Roles".equalsIgnoreCase(principal2.getName())) continue;
            Enumeration enumeration = ((Group)principal2).members();
            while (enumeration.hasMoreElements()) {
                roles.add(((Principal)enumeration.nextElement()).getName());
            }
        }
        identity.withRoleMapper(roleCategory, rolesToMap -> Roles.fromSet((Set)roles));
        IdentityCredentials publicCredentials = IdentityCredentials.NONE;
        for (Object object : subject.getPublicCredentials()) {
            if (object instanceof PublicKey) {
                publicCredentials = publicCredentials.withCredential((Credential)new PublicKeyCredential((PublicKey)object));
                continue;
            }
            if (object instanceof X509Certificate) {
                publicCredentials = publicCredentials.withCredential((Credential)new X509CertificateChainPublicCredential(new X509Certificate[]{(X509Certificate)object}));
                continue;
            }
            if (!(object instanceof Credential)) continue;
            publicCredentials = publicCredentials.withCredential((Credential)object);
        }
        identity.withPublicCredentials(publicCredentials);
        IdentityCredentials identityCredentials = IdentityCredentials.NONE;
        for (Object credential : subject.getPrivateCredentials()) {
            if (credential instanceof Password) {
                IdentityCredentials identityCredentials2 = var7_10.withCredential((Credential)new PasswordCredential((Password)credential));
                continue;
            }
            if (credential instanceof SecretKey) {
                IdentityCredentials identityCredentials3 = var7_10.withCredential((Credential)new SecretKeyCredential((SecretKey)credential));
                continue;
            }
            if (credential instanceof KeyPair) {
                IdentityCredentials identityCredentials4 = var7_10.withCredential((Credential)new KeyPairCredential((KeyPair)credential));
                continue;
            }
            if (credential instanceof PrivateKey) {
                IdentityCredentials identityCredentials5 = var7_10.withCredential((Credential)new X509CertificateChainPrivateCredential((PrivateKey)credential, new X509Certificate[0]));
                continue;
            }
            if (!(credential instanceof Credential)) continue;
            IdentityCredentials identityCredentials6 = var7_10.withCredential((Credential)credential);
        }
        identity.withPrivateCredentials((IdentityCredentials)var7_10);
        return identity;
    }

    private static class SimpleGroup
    implements Group {
        private final String name;
        private final Set<Principal> principals;

        SimpleGroup(String name) {
            this.name = name;
            this.principals = new HashSet<Principal>();
        }

        public String getName() {
            return this.name;
        }

        public boolean addMember(Principal principal) {
            return this.principals.add(principal);
        }

        public boolean removeMember(Principal principal) {
            return this.principals.remove(principal);
        }

        public Enumeration<? extends Principal> members() {
            return Collections.enumeration(this.principals);
        }

        public boolean isMember(Principal principal) {
            return this.principals.contains(principal);
        }
    }
}

