/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.aesh.readline.AeshConsoleBuffer;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.completion.SimpleCompletionHandler;
import org.aesh.readline.cursor.CursorListener;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.Config;

public class Readline {
    private static final Logger LOGGER = LoggerUtil.getLogger(Readline.class.getName());
    private final ActionDecoder decoder;
    private AeshInputProcessor inputProcessor;
    private CompletionHandler completionHandler;
    private EditMode editMode;
    private History history;

    public Readline() {
        this(EditModeBuilder.builder().create());
    }

    public Readline(EditMode editMode) {
        this(editMode, new InMemoryHistory(), null);
        this.history.enable();
    }

    public Readline(EditMode editMode, History history, CompletionHandler completionHandler) {
        this.editMode = editMode;
        this.history = history;
        this.completionHandler = completionHandler == null ? new SimpleCompletionHandler() : completionHandler;
        this.decoder = new ActionDecoder(this.editMode);
    }

    protected InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInput() {
        Readline readline = this;
        synchronized (readline) {
            while (this.decoder.hasNext() && this.inputProcessor != null && !this.inputProcessor.paused) {
                this.inputProcessor.parse(this.decoder.next());
            }
            return;
        }
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler) {
        this.readline(conn, new Prompt(prompt), requestHandler, null);
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler, List<Completion> completions) {
        this.readline(conn, new Prompt(prompt), requestHandler, completions);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler) {
        this.readline(conn, prompt, requestHandler, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions) {
        this.readline(conn, prompt, requestHandler, completions, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors) {
        this.readline(conn, prompt, requestHandler, completions, preProcessors, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History history) {
        this.readline(conn, prompt, requestHandler, completions, preProcessors, history, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History history, CursorListener listener) {
        this.readline(conn, prompt, requestHandler, completions, preProcessors, history, listener, new EnumMap<ReadlineFlag, Integer>(ReadlineFlag.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History history, CursorListener listener, EnumMap<ReadlineFlag, Integer> flags) {
        Readline readline = this;
        synchronized (readline) {
            if (this.inputProcessor != null) {
                throw new IllegalStateException("Already reading a line");
            }
            this.inputProcessor = new AeshInputProcessor(conn, prompt, requestHandler, completions, preProcessors, history, listener, flags);
            this.inputProcessor.start();
            if (this.inputProcessor != null) {
                this.processInput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInput() {
        Readline readline = this;
        synchronized (readline) {
            if (this.inputProcessor == null) {
                LOGGER.warning("No inputprocessor in Readline.processInput");
            } else if (this.decoder.hasNext()) {
                this.readInput();
            }
        }
    }

    private class AeshInputProcessor
    implements InputProcessor {
        private final Connection conn;
        private Consumer<int[]> prevReadHandler;
        private Consumer<Size> prevSizeHandler;
        private Consumer<Signal> prevSignalHandler;
        private final Consumer<String> requestHandler;
        private boolean paused;
        private final ConsoleBuffer consoleBuffer;
        private String returnValue;
        private List<Function<String, Optional<String>>> preProcessors;
        private Attributes attributes;
        private final EnumMap<ReadlineFlag, Integer> flags;

        private AeshInputProcessor(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions, List<Function<String, Optional<String>>> preProcessors, History newHistory, CursorListener listener, EnumMap<ReadlineFlag, Integer> flags) {
            Readline.this.completionHandler.clear();
            Readline.this.completionHandler.addCompletions(completions);
            this.consoleBuffer = new AeshConsoleBuffer(conn, prompt, Readline.this.editMode, newHistory != null ? newHistory : Readline.this.history, Readline.this.completionHandler, true, listener);
            this.conn = conn;
            this.requestHandler = requestHandler;
            this.preProcessors = preProcessors;
            this.attributes = conn.getAttributes();
            this.flags = flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(String s) {
            this.conn.setStdinHandler(this.prevReadHandler);
            this.conn.setSizeHandler(this.prevSizeHandler);
            this.conn.setSignalHandler(this.prevSignalHandler);
            Readline readline = Readline.this;
            synchronized (readline) {
                Readline.this.inputProcessor = null;
            }
            this.conn.setAttributes(this.attributes);
            this.requestHandler.accept(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(KeyAction event) {
            Action action = Readline.this.editMode.parse(event);
            if (action != null) {
                Readline readline = Readline.this;
                synchronized (readline) {
                    this.paused = true;
                }
                action.accept(this);
                Readline.this.editMode.setPrevKey(event);
                if (this.returnValue() != null) {
                    this.conn.stdoutHandler().accept(Config.CR);
                    this.finish(this.returnValue());
                } else {
                    readline = Readline.this;
                    synchronized (readline) {
                        this.paused = false;
                    }
                    if (Readline.this.inputProcessor != null) {
                        Readline.this.processInput();
                    }
                }
            } else if (Key.isPrintable(event.buffer()) && this.notInCommandNode()) {
                this.buffer().writeChar((char)event.buffer().array()[0]);
            }
        }

        private boolean notInCommandNode() {
            return Readline.this.editMode.mode() != EditMode.Mode.VI || Readline.this.editMode.status() != EditMode.Status.COMMAND;
        }

        private void start() {
            this.prevReadHandler = this.conn.getStdinHandler();
            this.prevSizeHandler = this.conn.getSizeHandler();
            this.prevSignalHandler = this.conn.getSignalHandler();
            this.conn.setSignalHandler(signal -> {
                if (signal != null) {
                    switch (signal) {
                        case INT: {
                            if (Readline.this.editMode.isInChainedAction()) {
                                this.parse(Key.CTRL_C);
                            } else {
                                if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHOCTL)) {
                                    this.conn.stdoutHandler().accept(new int[]{94, 67});
                                }
                                if (!this.flags.containsKey((Object)ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR)) {
                                    this.conn.stdoutHandler().accept(Config.CR);
                                    this.buffer().buffer().reset();
                                    this.consoleBuffer.drawLine();
                                }
                            }
                            if (this.prevSignalHandler == null) break;
                            this.prevSignalHandler.accept((Signal)((Object)signal));
                            break;
                        }
                        case CONT: {
                            this.conn.enterRawMode();
                            this.resize(this.conn.size());
                            break;
                        }
                        case EOF: {
                            this.parse(Key.CTRL_D);
                            break;
                        }
                    }
                }
            });
            this.conn.setSizeHandler(this::resize);
            this.attributes = this.conn.enterRawMode();
            this.consoleBuffer.drawLine();
            this.conn.setStdinHandler(data -> {
                Readline readline = Readline.this;
                synchronized (readline) {
                    Readline.this.decoder.add((int[])data);
                }
                Readline.this.readInput();
            });
        }

        private void resize(Size size) {
            if (((Readline)Readline.this).inputProcessor.consoleBuffer.buffer().length() > 0) {
                int[] buffer = Readline.this.inputProcessor.buffer().buffer().multiLine();
                ((Readline)Readline.this).inputProcessor.consoleBuffer.setSize(size);
                ((Readline)Readline.this).inputProcessor.consoleBuffer.replace(buffer);
            } else {
                ((Readline)Readline.this).inputProcessor.consoleBuffer.setSize(size);
            }
        }

        @Override
        public String returnValue() {
            return this.returnValue;
        }

        @Override
        public ConsoleBuffer buffer() {
            return this.consoleBuffer;
        }

        @Override
        public void setReturnValue(int[] in) {
            String input = Parser.fromCodePoints(in);
            if (this.preProcessors != null && this.preProcessors.size() > 0) {
                this.preProcessors.forEach(pre -> ((Optional)pre.apply(input)).ifPresent(v -> {
                    this.returnValue = v;
                }));
            }
            if (this.returnValue == null) {
                this.returnValue = input;
            }
        }

        @Override
        public EditMode editMode() {
            return Readline.this.editMode;
        }

        @Override
        public void setEditMode(EditMode edit) {
            if (edit != null) {
                Readline.this.editMode = edit;
                Readline.this.decoder.setMappings(Readline.this.editMode);
            }
        }

        @Override
        public Connection connection() {
            return this.conn;
        }

        @Override
        public EnumMap<ReadlineFlag, Integer> flags() {
            return this.flags;
        }
    }
}

