/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceDefinition;
import org.wildfly.extension.datasources.agroal.DataSourceOperations;
import org.wildfly.extension.datasources.agroal.DataSourceService;
import org.wildfly.extension.datasources.agroal.XADataSourceOperations;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;
import org.wildfly.security.auth.client.AuthenticationContext;

class AbstractDataSourceOperations {
    static final OperationStepHandler STATISTICS_ENABLED_WRITE_OPERATION = new StatisticsEnabledAttributeWriter(new AttributeDefinition[]{AbstractDataSourceDefinition.STATISTICS_ENABLED_ATTRIBUTE});
    static final OperationStepHandler CONNECTION_FACTORY_WRITE_OPERATION = new ConnectionFactoryAttributeWriter(AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE.getValueTypes());
    static final OperationStepHandler CONNECTION_POOL_WRITE_OPERATION = new ConnectionPoolAttributeWriter(AbstractDataSourceDefinition.CONNECTION_POOL_ATTRIBUTE.getValueTypes());
    static final OperationStepHandler FLUSH_ALL_OPERATION = new FlushOperation(AgroalDataSource.FlushMode.ALL);
    static final OperationStepHandler FLUSH_GRACEFUL_OPERATION = new FlushOperation(AgroalDataSource.FlushMode.GRACEFUL);
    static final OperationStepHandler FLUSH_INVALID_OPERATION = new FlushOperation(AgroalDataSource.FlushMode.INVALID);
    static final OperationStepHandler FLUSH_IDLE_OPERATION = new FlushOperation(AgroalDataSource.FlushMode.IDLE);
    static final OperationStepHandler RESET_STATISTICS_OPERATION = new ResetStatisticsOperation();
    static final OperationStepHandler STATISTICS_GET_OPERATION = new StatisticsGetOperation();
    static final OperationStepHandler TEST_CONNECTION_OPERATION = new TestConnectionOperation();

    AbstractDataSourceOperations() {
    }

    protected static AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        AgroalConnectionFactoryConfigurationSupplier configuration = new AgroalConnectionFactoryConfigurationSupplier();
        if (AbstractDataSourceDefinition.URL_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            configuration.jdbcUrl(AbstractDataSourceDefinition.URL_ATTRIBUTE.resolveModelAttribute(context, model).asString());
        }
        if (AbstractDataSourceDefinition.NEW_CONNECTION_SQL_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            configuration.initialSql(AbstractDataSourceDefinition.NEW_CONNECTION_SQL_ATTRIBUTE.resolveModelAttribute(context, model).asString());
        }
        if (AbstractDataSourceDefinition.TRANSACTION_ISOLATION_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            configuration.jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)AbstractDataSourceDefinition.TRANSACTION_ISOLATION_ATTRIBUTE.resolveModelAttribute(context, model).asString()));
        }
        if (AbstractDataSourceDefinition.CONNECTION_PROPERTIES_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            for (Property jdbcProperty : AbstractDataSourceDefinition.CONNECTION_PROPERTIES_ATTRIBUTE.resolveModelAttribute(context, model).asPropertyList()) {
                configuration.jdbcProperty(jdbcProperty.getName(), jdbcProperty.getValue().asString());
            }
        }
        if (AbstractDataSourceDefinition.USERNAME_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            configuration.principal((Principal)new NamePrincipal(AbstractDataSourceDefinition.USERNAME_ATTRIBUTE.resolveModelAttribute(context, model).asString()));
        }
        if (AbstractDataSourceDefinition.PASSWORD_ATTRIBUTE.resolveModelAttribute(context, model).isDefined()) {
            configuration.credential((Object)new SimplePassword(AbstractDataSourceDefinition.PASSWORD_ATTRIBUTE.resolveModelAttribute(context, model).asString()));
        }
        return configuration;
    }

    protected static void setupElytronSecurity(OperationContext context, ModelNode model, DataSourceService dataSourceService, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        if (AbstractDataSourceDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).isDefined()) {
            String authenticationContextName = AbstractDataSourceDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).asString();
            ServiceName authenticationContextCapability = context.getCapabilityServiceName("org.wildfly.security.authentication-context", authenticationContextName, AuthenticationContext.class);
            serviceBuilder.addDependency(authenticationContextCapability, AuthenticationContext.class, dataSourceService.getAuthenticationContextInjector());
        }
        if (AbstractDataSourceDefinition.CREDENTIAL_REFERENCE.resolveModelAttribute(context, model).isDefined()) {
            ExceptionSupplier credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)AbstractDataSourceDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, serviceBuilder);
            dataSourceService.getCredentialSourceSupplierInjector().inject((Object)credentialSourceSupplier);
        }
    }

    protected static AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        AgroalConnectionPoolConfigurationSupplier configuration = new AgroalConnectionPoolConfigurationSupplier();
        configuration.maxSize(AbstractDataSourceDefinition.MAX_SIZE_ATTRIBUTE.resolveModelAttribute(context, model).asInt());
        configuration.minSize(AbstractDataSourceDefinition.MIN_SIZE_ATTRIBUTE.resolveModelAttribute(context, model).asInt());
        configuration.initialSize(AbstractDataSourceDefinition.INITIAL_SIZE_ATTRIBUTE.resolveModelAttribute(context, model).asInt());
        configuration.acquisitionTimeout(Duration.ofMillis(AbstractDataSourceDefinition.BLOCKING_TIMEOUT_MILLIS_ATTRIBUTE.resolveModelAttribute(context, model).asInt()));
        configuration.leakTimeout(Duration.ofMillis(AbstractDataSourceDefinition.LEAK_DETECTION_ATTRIBUTE.resolveModelAttribute(context, model).asInt()));
        configuration.validationTimeout(Duration.ofMillis(AbstractDataSourceDefinition.BACKGROUND_VALIDATION_ATTRIBUTE.resolveModelAttribute(context, model).asInt()));
        configuration.reapTimeout(Duration.ofMinutes(AbstractDataSourceDefinition.IDLE_REMOVAL_ATTRIBUTE.resolveModelAttribute(context, model).asInt()));
        configuration.connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator());
        return configuration;
    }

    private static AgroalDataSource getDataSource(OperationContext context) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(false);
        String dataSourceName = context.getCurrentAddressValue();
        switch (context.getCurrentAddress().getLastElement().getKey()) {
            case "datasource": {
                ServiceController controller = registry.getRequiredService(DataSourceOperations.DATASOURCE_SERVICE_PREFIX.append(new String[]{dataSourceName}));
                return (AgroalDataSource)controller.getValue();
            }
            case "xa-datasource": {
                ServiceController xaController = registry.getRequiredService(XADataSourceOperations.XADATASOURCE_SERVICE_PREFIX.append(new String[]{dataSourceName}));
                return (AgroalDataSource)xaController.getValue();
            }
        }
        throw AgroalLogger.SERVICE_LOGGER.unknownDatasourceServiceType(context.getCurrentAddress().getLastElement().getKey());
    }

    private static class TestConnectionOperation
    implements OperationStepHandler {
        private TestConnectionOperation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                try (Connection connection = AbstractDataSourceOperations.getDataSource(context).getConnection();){
                    context.getResult().set(new ModelNode().add(connection.isValid(0)));
                }
                catch (SQLException e) {
                    throw AgroalLogger.SERVICE_LOGGER.invalidConnection(e, context.getCurrentAddressValue());
                }
            }
        }
    }

    private static class ResetStatisticsOperation
    implements OperationStepHandler {
        private ResetStatisticsOperation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                AbstractDataSourceOperations.getDataSource(context).getMetrics().reset();
            }
        }
    }

    private static class StatisticsGetOperation
    implements OperationStepHandler {
        private StatisticsGetOperation() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                AgroalDataSourceMetrics metrics = AbstractDataSourceOperations.getDataSource(context).getMetrics();
                ModelNode result = new ModelNode();
                result.get("acquire-count").set(metrics.acquireCount());
                result.get("active-count").set(metrics.activeCount());
                result.get("available-count").set(metrics.availableCount());
                result.get("awaiting-count").set(metrics.awaitingCount());
                result.get("creation-count").set(metrics.creationCount());
                result.get("destroy-count").set(metrics.destroyCount());
                result.get("flush-count").set(metrics.flushCount());
                result.get("invalid-count").set(metrics.invalidCount());
                result.get("leak-detection-count").set(metrics.leakDetectionCount());
                result.get("max-used-count").set(metrics.maxUsedCount());
                result.get("reap-count").set(metrics.reapCount());
                result.get("blocking-time-average-ms").set(metrics.blockingTimeAverage().toMillis());
                result.get("blocking-time-max-ms").set(metrics.blockingTimeMax().toMillis());
                result.get("blocking-time-total-ms").set(metrics.blockingTimeTotal().toMillis());
                result.get("creation-time-average-ms").set(metrics.creationTimeAverage().toMillis());
                result.get("creation-time-max-ms").set(metrics.creationTimeMax().toMillis());
                result.get("creation-time-total-ms").set(metrics.creationTimeTotal().toMillis());
                context.getResult().set(result);
            }
        }
    }

    private static class FlushOperation
    implements OperationStepHandler {
        private AgroalDataSource.FlushMode mode;

        private FlushOperation(AgroalDataSource.FlushMode mode) {
            this.mode = mode;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isNormalServer()) {
                AgroalLogger.SERVICE_LOGGER.flushOperation(this.mode);
                AbstractDataSourceOperations.getDataSource(context).flush(this.mode);
            }
        }
    }

    private static class ConnectionPoolAttributeWriter
    extends AbstractWriteAttributeHandler<AgroalConnectionPoolConfiguration> {
        private ConnectionPoolAttributeWriter(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<AgroalConnectionPoolConfiguration> handbackHolder) throws OperationFailedException {
            ModelNode newBlockingTimeout = resolvedValue.remove(AbstractDataSourceDefinition.BLOCKING_TIMEOUT_MILLIS_ATTRIBUTE.getName());
            ModelNode newMaxSize = resolvedValue.remove(AbstractDataSourceDefinition.MAX_SIZE_ATTRIBUTE.getName());
            ModelNode newMinSize = resolvedValue.remove(AbstractDataSourceDefinition.MIN_SIZE_ATTRIBUTE.getName());
            for (String attribute : resolvedValue.keys()) {
                if (currentValue.hasDefined(attribute) && resolvedValue.get(attribute).equals(currentValue.get(attribute))) continue;
                return true;
            }
            if (newBlockingTimeout != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setAcquisitionTimeout(Duration.ofMillis(newBlockingTimeout.asInt()));
            }
            if (newMaxSize != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setMaxSize(newMaxSize.asInt());
            }
            if (newMinSize != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setMinSize(newMinSize.asInt());
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, AgroalConnectionPoolConfiguration handback) throws OperationFailedException {
            ModelNode newBlockingTimeout = valueToRevert.remove(AbstractDataSourceDefinition.BLOCKING_TIMEOUT_MILLIS_ATTRIBUTE.getName());
            ModelNode newMaxSize = valueToRevert.remove(AbstractDataSourceDefinition.MAX_SIZE_ATTRIBUTE.getName());
            ModelNode newMinSize = valueToRevert.remove(AbstractDataSourceDefinition.MIN_SIZE_ATTRIBUTE.getName());
            if (newBlockingTimeout != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setAcquisitionTimeout(Duration.ofMillis(newBlockingTimeout.asInt()));
            }
            if (newMinSize != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setMinSize(newMinSize.asInt());
            }
            if (newMaxSize != null) {
                AbstractDataSourceOperations.getDataSource(context).getConfiguration().connectionPoolConfiguration().setMaxSize(newMaxSize.asInt());
            }
        }
    }

    private static class ConnectionFactoryAttributeWriter
    extends AbstractWriteAttributeHandler<AgroalConnectionFactoryConfiguration> {
        private ConnectionFactoryAttributeWriter(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<AgroalConnectionFactoryConfiguration> handbackHolder) throws OperationFailedException {
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, AgroalConnectionFactoryConfiguration handback) throws OperationFailedException {
        }
    }

    private static class StatisticsEnabledAttributeWriter
    extends AbstractWriteAttributeHandler<Boolean> {
        private StatisticsEnabledAttributeWriter(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            AbstractDataSourceOperations.getDataSource(context).getConfiguration().setMetricsEnabled(resolvedValue.asBoolean());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            AbstractDataSourceOperations.getDataSource(context).getConfiguration().setMetricsEnabled(valueToRevert.asBoolean());
        }
    }
}

