/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.JWEHeader;
import org.jboss.resteasy.jose.jwe.crypto.AESCBC;
import org.jboss.resteasy.jose.jwe.crypto.AESGCM;
import org.jboss.resteasy.jose.jwe.crypto.DeflateHelper;

public class DirectDecrypter {
    public static byte[] decrypt(SecretKey key, JWEHeader readOnlyJWEHeader, String encodedHeader, String encryptedKey, String encodedIv, String encodedCipherText, String encodedAuthTag) {
        byte[] plainText;
        if (encryptedKey != null) {
            throw new RuntimeException(Messages.MESSAGES.unexpectedEncryptedKey());
        }
        if (encodedIv == null) {
            throw new RuntimeException(Messages.MESSAGES.initializationVectorMustNotBeNull());
        }
        if (encodedAuthTag == null) {
            throw new RuntimeException(Messages.MESSAGES.authenticationTagMustNotBeNull());
        }
        Algorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals((Object)Algorithm.dir)) {
            throw new RuntimeException(Messages.MESSAGES.unsupportedAlgorithm());
        }
        byte[] aad = encodedHeader.getBytes(StandardCharsets.UTF_8);
        byte[] iv = Base64Url.decode(encodedIv);
        byte[] cipherText = Base64Url.decode(encodedCipherText);
        byte[] authTag = Base64Url.decode(encodedAuthTag);
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals((Object)EncryptionMethod.A128CBC_HS256) || enc.equals((Object)EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(key, iv, cipherText, aad, authTag);
        } else if (enc.equals((Object)EncryptionMethod.A128GCM) || enc.equals((Object)EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(key, iv, cipherText, aad, authTag);
        } else {
            throw new RuntimeException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return DeflateHelper.applyDecompression(readOnlyJWEHeader.getCompressionAlgorithm(), plainText);
    }
}

