/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;

class FileSystemRealmCommand
extends Command {
    static final int GENERAL_CONFIGURATION_WARNING = 1;
    static final String FILE_SYSTEM_REALM_COMMAND = "filesystem-realm";
    static final int SUMMARY_WIDTH = 100;
    private static final String HELP_PARAM = "help";
    private static final String DEBUG_PARAM = "debug";
    private static final String SILENT_PARAM = "silent";
    private static final String SUMMARY_PARAM = "summary";
    private static final String USERS_FILE_PARAM = "users-file";
    private static final String ROLES_FILE_PARAM = "roles-file";
    private static final String OUTPUT_LOCATION_PARAM = "output-location";
    private static final String FILESYSTEM_REALM_NAME_PARAM = "filesystem-realm-name";
    private static final String SECURITY_DOMAIN_NAME_PARAM = "security-domain-name";
    private static final String BULK_CONVERT_PARAM = "bulk-convert";
    private static final String FILE_ARG = "file";
    private static final String DIRECTORY_ARG = "directory";
    private static final String NAME_ARG = "name";
    private static final String DEFAULT_FILESYSTEM_REALM_NAME = "converted-properties-filesystem-realm";
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "converted-properties-security-domain";
    private List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final List<String> PARAMS_LIST = new ArrayList<String>(Arrays.asList("users-file", "roles-file", "output-location", "filesystem-realm-name", "security-domain-name"));
    private Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;
    private boolean silentMode = false;
    private boolean summaryMode = false;
    private StringBuilder summaryString = null;
    private boolean warningOccurred = false;

    FileSystemRealmCommand() {
        this.options = new Options();
        Option option = new Option("u", USERS_FILE_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmUsersFileDesc());
        option.setArgName(FILE_ARG);
        this.options.addOption(option);
        option = new Option("r", ROLES_FILE_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmRolesFileDesc());
        option.setArgName(FILE_ARG);
        this.options.addOption(option);
        option = new Option("o", OUTPUT_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmOutputLocationDesc());
        option.setArgName(DIRECTORY_ARG);
        this.options.addOption(option);
        option = new Option("b", BULK_CONVERT_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmBulkConvertDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("f", FILESYSTEM_REALM_NAME_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmFileSystemRealmNameDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("s", SECURITY_DOMAIN_NAME_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmSecurityDomainNameDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = Option.builder().longOpt(HELP_PARAM).desc(ElytronToolMessages.msg.cmdLineHelp()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(DEBUG_PARAM).desc(ElytronToolMessages.msg.cmdLineDebug()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(SILENT_PARAM).desc(ElytronToolMessages.msg.cmdFileSystemRealmSilentDesc()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(SUMMARY_PARAM).desc(ElytronToolMessages.msg.cmdFileSystemRealmSummaryDesc()).build();
        this.options.addOption(option);
    }

    @Override
    public void execute(String[] args) throws Exception {
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption(DEBUG_PARAM));
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        if (this.cmdLine.hasOption(SILENT_PARAM)) {
            this.silentMode = true;
        }
        if (this.cmdLine.hasOption(SUMMARY_PARAM)) {
            this.summaryMode = true;
            this.summaryString = new StringBuilder();
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append("Summary for execution of Elytron-Tool command FileSystemRealm");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
        }
        this.printDuplicatesWarning(this.cmdLine);
        String bulkConvert = this.cmdLine.getOptionValue("b");
        String usersFileOption = this.cmdLine.getOptionValue("u");
        String rolesFileOption = this.cmdLine.getOptionValue("r");
        String outputLocationOption = this.cmdLine.getOptionValue("o");
        if (bulkConvert == null) {
            if (this.summaryMode) {
                this.summaryString.append("Options were specified via CLI, converting single users-roles combination");
                this.summaryString.append(System.getProperty("line.separator"));
            }
            if (usersFileOption == null) {
                this.errorHandler(ElytronToolMessages.msg.missingUsersFile());
            } else if (rolesFileOption == null) {
                this.errorHandler(ElytronToolMessages.msg.missingRolesFile());
            } else if (outputLocationOption == null) {
                this.errorHandler(ElytronToolMessages.msg.missingOutputLocation());
            }
            Descriptor descriptor = new Descriptor();
            descriptor.setUsersFile(usersFileOption);
            descriptor.setRolesFile(rolesFileOption);
            descriptor.setOutputLocation(outputLocationOption);
            descriptor.setFileSystemRealmName(this.cmdLine.getOptionValue("f"));
            descriptor.setSecurityDomainName(this.cmdLine.getOptionValue("s"));
            this.descriptors.add(descriptor);
            this.findMissingRequiredValuesAndSetValues(0, descriptor);
        } else {
            if (usersFileOption != null || rolesFileOption != null || outputLocationOption != null) {
                throw ElytronToolMessages.msg.mutuallyExclusiveOptionsSpecified();
            }
            if (this.summaryMode) {
                this.summaryString.append(String.format("Options were specified via descriptor file: %s, converting multiple users-roles combinations", bulkConvert));
                this.summaryString.append(System.getProperty("line.separator"));
            }
            this.parseDescriptorFile(bulkConvert);
        }
        this.createFileSystemRealm();
        this.createWildFlyScript();
        if (this.summaryMode) {
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append("End of summary");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            System.out.println(this.summaryString);
        }
        if (this.warningOccurred) {
            this.setStatus(1);
        } else {
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        }
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp(this.getToolCommand(), FILE_SYSTEM_REALM_COMMAND), ElytronToolMessages.msg.cmdFileSystemRealmHelpHeader(), this.options, "", true);
    }

    private void warningHandler(String warning) {
        this.warningOccurred = true;
        if (!this.silentMode) {
            System.out.print("WARNING: ");
            System.out.println(warning);
        }
        if (this.summaryMode) {
            this.summaryString.append("WARNING: ");
            this.summaryString.append(warning);
            this.summaryString.append(System.getProperty("line.separator"));
        }
    }

    private void errorHandler(Exception e) throws Exception {
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        if (this.summaryMode) {
            this.summaryString.append("Error was thrown during execution:");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(e.getMessage());
            System.out.println(System.getProperty("line.separator") + this.summaryString.toString());
        }
        throw e;
    }

    private void printDescriptorBlocks(int count) {
        this.summaryString.append(System.getProperty("line.separator"));
        this.summaryString.append(System.getProperty("line.separator"));
        this.summaryString.append("Found following users-roles combinations, null indicates missing required component:");
        this.summaryString.append(System.getProperty("line.separator"));
        for (int i = 0; i < count; ++i) {
            StringBuilder summary = new StringBuilder();
            summary.append("\tPrinting summary for block ");
            summary.append(i + 1);
            summary.append(System.getProperty("line.separator"));
            Descriptor descriptor = this.descriptors.get(i);
            for (String param : this.PARAMS_LIST) {
                summary.append("\t\t");
                summary.append(param);
                summary.append(" - ");
                summary.append(this.getDescriptorParam(param, descriptor));
                summary.append(System.getProperty("line.separator"));
            }
            this.summaryString.append((CharSequence)summary);
        }
        this.summaryString.append(System.getProperty("line.separator"));
    }

    private String getDescriptorParam(String param, Descriptor descriptor) {
        switch (param) {
            case "users-file": {
                return descriptor.getUsersFile();
            }
            case "roles-file": {
                return descriptor.getRolesFile();
            }
            case "output-location": {
                return descriptor.getOutputLocation();
            }
            case "filesystem-realm-name": {
                return descriptor.getFileSystemRealmName();
            }
            case "security-domain-name": {
                return descriptor.getSecurityDomainName();
            }
        }
        return null;
    }

    private void parseDescriptorFile(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        if (!path.toFile().exists()) {
            this.errorHandler(ElytronToolMessages.msg.fileNotFound(file));
        }
        Descriptor descriptor = new Descriptor();
        AtomicInteger count = new AtomicInteger(1);
        try (Stream<String> stream = Files.lines(path);){
            stream.forEach(line -> {
                if (line.equals("")) {
                    this.findMissingRequiredValuesAndSetValues(count.intValue(), descriptor);
                    this.copyAddResetDescriptor(descriptor);
                    count.getAndIncrement();
                } else {
                    String[] parts = line.split(":", 2);
                    String option = parts[0];
                    String arg = parts[1];
                    switch (option) {
                        case "users-file": {
                            descriptor.setUsersFile(arg);
                            break;
                        }
                        case "roles-file": {
                            descriptor.setRolesFile(arg);
                            break;
                        }
                        case "output-location": {
                            descriptor.setOutputLocation(arg);
                            break;
                        }
                        case "filesystem-realm-name": {
                            descriptor.setFileSystemRealmName(arg);
                            break;
                        }
                        case "security-domain-name": {
                            descriptor.setSecurityDomainName(arg);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            this.errorHandler(e);
        }
        int currentCount = count.intValue();
        this.findMissingRequiredValuesAndSetValues(currentCount, descriptor);
        this.copyAddResetDescriptor(descriptor);
        if (this.summaryMode) {
            this.printDescriptorBlocks(currentCount);
        }
        count.getAndIncrement();
    }

    private void copyAddResetDescriptor(Descriptor original) {
        Descriptor temp = new Descriptor(original);
        this.descriptors.add(temp);
        original.reset();
    }

    private void findMissingRequiredValuesAndSetValues(int count, Descriptor descriptor) {
        boolean missingRequiredValue = false;
        if (descriptor.getUsersFile() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlock(count, "missing users-file"));
            missingRequiredValue = true;
        }
        if (descriptor.getRolesFile() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlock(count, "missing roles-file"));
            missingRequiredValue = true;
        }
        if (descriptor.getOutputLocation() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlock(count, "missing output-location"));
            missingRequiredValue = true;
        }
        if (missingRequiredValue) {
            descriptor.reset();
        }
    }

    private List<String> parseInputFile(Descriptor descriptor, String param, int count) throws Exception {
        ArrayList<String> entries = new ArrayList<String>();
        String paramValue = this.getDescriptorParam(param, descriptor);
        boolean valueValid = true;
        Path path = null;
        if (paramValue == null) {
            this.warningHandler(ElytronToolMessages.msg.noValueFound(param));
            valueValid = false;
        } else {
            path = Paths.get(paramValue, new String[0]);
            if (!path.toFile().exists()) {
                if (this.descriptors.size() == 1) {
                    this.errorHandler(ElytronToolMessages.msg.fileNotFound(paramValue));
                }
                this.warningHandler(ElytronToolMessages.msg.fileNotFound(paramValue).getMessage());
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlock(count, String.format("could not find file for %s", param)));
                valueValid = false;
            }
        }
        if (valueValid) {
            try (Stream<String> stream = Files.lines(path);){
                stream.forEach(line -> {
                    if (line.startsWith("#$REALM_NAME=")) {
                        line = line.substring(line.indexOf("=") + 1);
                        line = line.substring(0, line.indexOf("$"));
                        descriptor.setRealmName((String)line);
                    } else if (!line.startsWith("#")) {
                        entries.add((String)line);
                    }
                });
            }
        }
        return entries;
    }

    private void createFileSystemRealm() throws Exception {
        Security.addProvider(new WildFlyElytronProvider());
        for (int i = 0; i < this.descriptors.size(); ++i) {
            ArrayList<String> userAttributes;
            String message;
            String user;
            Descriptor descriptor = this.descriptors.get(i);
            if (descriptor.getUsersFile() == null || descriptor.getRolesFile() == null || descriptor.getOutputLocation() == null) continue;
            List<String> usersList = this.parseInputFile(descriptor, USERS_FILE_PARAM, i + 1);
            List<String> rolesList = this.parseInputFile(descriptor, ROLES_FILE_PARAM, i + 1);
            if (usersList.isEmpty() || rolesList.isEmpty()) {
                descriptor.reset();
                continue;
            }
            FileSystemSecurityRealm newFileSystemRealm = new FileSystemSecurityRealm(Paths.get(descriptor.getOutputLocation(), new String[0]));
            HashMap<String, ArrayList> usersMap = new HashMap<String, ArrayList>();
            for (String userMapping : usersList) {
                String password;
                String[] userStringSplit = userMapping.split("=");
                user = userStringSplit[0].trim();
                if (userStringSplit.length == 1) {
                    message = String.format("No password was found for user %s", user);
                    this.warningHandler(message);
                    password = null;
                } else {
                    password = userStringSplit[1].trim();
                }
                userAttributes = new ArrayList<String>();
                userAttributes.add(password);
                usersMap.put(user, userAttributes);
            }
            for (String rolesMapping : rolesList) {
                String[] rolesStringSplit = rolesMapping.split("=");
                user = rolesStringSplit[0].trim();
                String[] roles = new String[]{};
                if (rolesStringSplit.length < 2) {
                    message = String.format("No roles were found for user %s", user);
                    this.warningHandler(message);
                } else {
                    roles = rolesStringSplit[1].trim().split(",");
                }
                userAttributes = (ArrayList<String>)usersMap.get(user);
                if (userAttributes == null) {
                    String message2 = String.format("Roles were found for user %1$s, but user %1$s was not defined.", user);
                    this.warningHandler(message2);
                    ArrayList<String> attributesWithEmptyPassword = new ArrayList<String>();
                    attributesWithEmptyPassword.add(null);
                    attributesWithEmptyPassword.addAll(new ArrayList<String>(Arrays.asList(roles)));
                    userAttributes = attributesWithEmptyPassword;
                    usersMap.put(user, userAttributes);
                } else {
                    userAttributes.addAll(Arrays.asList(roles));
                    usersMap.replace(user, userAttributes);
                }
                if (!this.summaryMode) continue;
                this.summaryString.append(String.format("Added roles: %s for user %s.", ArrayUtils.toString((Object)roles), user));
                this.summaryString.append(System.getProperty("line.separator"));
            }
            usersMap.forEach((key, value) -> {
                ModifiableRealmIdentity identity = newFileSystemRealm.getRealmIdentityForUpdate(new NamePrincipal((String)key));
                try {
                    identity.create();
                    MapAttributes attributes = new MapAttributes();
                    attributes.addAll("roles", value.subList(1, value.size()));
                    identity.setAttributes(attributes);
                    String password = (String)value.get(0);
                    if (password != null) {
                        byte[] hashed = ByteIterator.ofBytes(password.getBytes(StandardCharsets.UTF_8)).asUtf8String().hexDecode().drain();
                        DigestPasswordSpec passwordSpec = new DigestPasswordSpec((String)key, descriptor.getRealmName(), hashed);
                        PasswordFactory factory = PasswordFactory.getInstance("digest-md5");
                        DigestPassword digestPassword = (DigestPassword)factory.generatePassword(passwordSpec);
                        identity.setCredentials(Collections.singleton(new PasswordCredential(digestPassword)));
                    }
                    identity.dispose();
                }
                catch (NullPointerException e) {
                    this.warningHandler(String.format("Could not read realm name from the users file", new Object[0]));
                }
                catch (Exception e) {
                    this.warningHandler(String.format("Could not create realm for user %s due to error: ", key) + e.getMessage());
                }
            });
        }
    }

    private void createWildFlyScript() throws Exception {
        for (Descriptor descriptor : this.descriptors) {
            String usersFile = descriptor.getUsersFile();
            if (descriptor.getUsersFile() == null || descriptor.getRolesFile() == null || descriptor.getOutputLocation() == null) continue;
            String fileSystemRealmName = descriptor.getFileSystemRealmName();
            if (fileSystemRealmName == null || fileSystemRealmName.isEmpty()) {
                this.warningHandler(String.format("No name provided for filesystem-realm, using default filesystem-realm name for %s.", usersFile));
                descriptor.setFileSystemRealmName(DEFAULT_FILESYSTEM_REALM_NAME);
                fileSystemRealmName = DEFAULT_FILESYSTEM_REALM_NAME;
            }
            String outputLocation = descriptor.getOutputLocation();
            String securityDomainName = descriptor.getSecurityDomainName();
            String createScriptCheck = "";
            if (Paths.get(String.format("%s.sh", fileSystemRealmName), new String[0]).toFile().exists()) {
                createScriptCheck = this.prompt(false, null, false, ElytronToolMessages.msg.shouldFileBeOverwritten(String.format("%s.sh", fileSystemRealmName)));
            }
            String fullOutputPath = outputLocation.startsWith(".") ? Paths.get(outputLocation.substring(2, outputLocation.length()), new String[0]).toAbsolutePath().toString() : Paths.get(outputLocation, new String[0]).toAbsolutePath().toString();
            if (this.summaryMode) {
                this.summaryString.append(String.format("Configured script for WildFly named %s.sh at %s.", fileSystemRealmName, fullOutputPath));
                this.summaryString.append(System.getProperty("line.separator"));
                this.summaryString.append("The script is using the following names:");
                this.summaryString.append(System.getProperty("line.separator"));
                this.summaryString.append(String.format("Name of filesystem-realm: %s", fileSystemRealmName));
                this.summaryString.append(System.getProperty("line.separator"));
            }
            if (securityDomainName != null && !securityDomainName.isEmpty()) {
                if (this.summaryMode) {
                    this.summaryString.append(String.format("Name of security-domain: %s", securityDomainName));
                    this.summaryString.append(System.getProperty("line.separator"));
                }
            } else {
                this.warningHandler(String.format("No name provided for security-domain, using default security-domain name for %s.", usersFile));
                securityDomainName = DEFAULT_SECURITY_DOMAIN_NAME;
            }
            List<String> scriptLines = Arrays.asList(String.format("/subsystem=elytron/filesystem-realm=%s:add(path=%s)", fileSystemRealmName, fullOutputPath), String.format("/subsystem=elytron/security-domain=%1$s:add(realms=[{realm=%2$s}],default-realm=%2$s,permission-mapper=default-permission-mapper)", securityDomainName, fileSystemRealmName));
            if (!createScriptCheck.equals("y") && !createScriptCheck.equals("yes")) {
                Files.write(Paths.get(String.format("%s/%s.sh", outputLocation, fileSystemRealmName), new String[0]), scriptLines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                continue;
            }
            Files.write(Paths.get(String.format("%s/%s.sh", outputLocation, fileSystemRealmName), new String[0]), scriptLines, StandardOpenOption.APPEND);
        }
    }

    private static final class Descriptor {
        private String usersFile;
        private String rolesFile;
        private String outputLocation;
        private String fileSystemRealmName;
        private String securityDomainName;
        private String realmName;

        Descriptor() {
        }

        Descriptor(Descriptor descriptor) {
            this.usersFile = descriptor.usersFile;
            this.rolesFile = descriptor.rolesFile;
            this.outputLocation = descriptor.outputLocation;
            this.fileSystemRealmName = descriptor.fileSystemRealmName;
            this.securityDomainName = descriptor.securityDomainName;
            this.realmName = descriptor.realmName;
        }

        String getUsersFile() {
            return this.usersFile;
        }

        String getRolesFile() {
            return this.rolesFile;
        }

        String getOutputLocation() {
            return this.outputLocation;
        }

        String getFileSystemRealmName() {
            return this.fileSystemRealmName;
        }

        String getSecurityDomainName() {
            return this.securityDomainName;
        }

        String getRealmName() {
            return this.realmName;
        }

        void setUsersFile(String usersFile) {
            this.usersFile = usersFile;
        }

        void setRolesFile(String rolesFile) {
            this.rolesFile = rolesFile;
        }

        void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        void setFileSystemRealmName(String fileSystemRealmName) {
            this.fileSystemRealmName = fileSystemRealmName;
        }

        void setSecurityDomainName(String securityDomainName) {
            this.securityDomainName = securityDomainName;
        }

        void setRealmName(String realmName) {
            this.realmName = realmName;
        }

        void reset() {
            this.usersFile = null;
            this.rolesFile = null;
            this.outputLocation = null;
            this.fileSystemRealmName = null;
            this.securityDomainName = null;
            this.realmName = null;
        }
    }
}

