/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import io.airlift.airline.Option;
import org.apache.activemq.artemis.cli.commands.AbstractAction;

public abstract class AddressAbstract
extends AbstractAction {
    @Option(name={"--name"}, description="The name of this address")
    private String name;
    @Option(name={"--anycast"}, description="It will determine this address as anycast")
    private Boolean anycast;
    @Option(name={"--no-anycast"}, description="It will determine this address as anycast")
    private Boolean noAnycast;
    @Option(name={"--multicast"}, description="It will determine this address as multicast")
    private Boolean multicast;
    @Option(name={"--no-multicast"}, description="It will determine this address as multicast")
    private Boolean noMulticast;

    public void setName(String name) {
        this.name = name;
    }

    public String getName(boolean requireInput) {
        if (this.name == null && requireInput) {
            this.name = this.input("--name", "Provide the name of the address", null);
        }
        return this.name;
    }

    public String getRoutingTypes(boolean useDefault) {
        StringBuffer buffer = new StringBuffer();
        if (this.isAnycast()) {
            buffer.append("ANYCAST");
        }
        if (this.isMulticast()) {
            if (this.isAnycast()) {
                buffer.append(",");
            }
            buffer.append("MULTICAST");
        }
        if (!this.isAnycast() && !this.isMulticast()) {
            if (useDefault) {
                return "MULTICAST";
            }
            return null;
        }
        return buffer.toString();
    }

    public boolean isAnycast() {
        if (this.noAnycast != null) {
            this.anycast = this.noAnycast == false;
        }
        if (this.anycast == null) {
            this.anycast = this.inputBoolean("--anycast", "Will this address support anycast queues", false);
        }
        return this.anycast;
    }

    public AddressAbstract setAnycast(boolean anycast) {
        this.anycast = anycast;
        return this;
    }

    public boolean isMulticast() {
        if (this.noMulticast != null) {
            this.multicast = this.noMulticast == false;
        }
        if (this.multicast == null) {
            this.multicast = this.inputBoolean("--multicast", "Will this address support multicast queues", true);
        }
        return this.multicast;
    }

    public AddressAbstract setMulticast(boolean multicast) {
        this.multicast = multicast;
        return this;
    }
}

