/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.AccessLogAttribute;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.EventLoggerService;
import org.wildfly.extension.undertow.ExchangeAttributeDefinitions;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowExtension;
import org.xnio.XnioWorker;

class ConsoleAccessLogDefinition
extends PersistentResourceDefinition {
    private static final RuntimeCapability<Void> CONSOLE_ACCESS_LOG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.host.console-access-log", (boolean)true, EventLoggerService.class).setDynamicNameMapper(DynamicNameMappers.GRAND_PARENT).build();
    static final SimpleAttributeDefinition INCLUDE_HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"include-host-name", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition METADATA = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("metadata", true).setAllowExpression(true)).setRestartAllServices()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(ExchangeAttributeDefinitions.ATTRIBUTES, INCLUDE_HOST_NAME, AccessLogDefinition.WORKER, AccessLogDefinition.PREDICATE, METADATA);
    static final ConsoleAccessLogDefinition INSTANCE = new ConsoleAccessLogDefinition();

    private ConsoleAccessLogDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"setting", (String)"console-access-log"), (ResourceDescriptionResolver)UndertowExtension.getResolver("console-access-log")).setAddHandler((OperationStepHandler)AddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)RemoveHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{CONSOLE_ACCESS_LOG_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    private static class RemoveHandler
    extends AbstractRemoveStepHandler {
        static final RemoveHandler INSTANCE = new RemoveHandler();

        private RemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            context.removeService(CONSOLE_ACCESS_LOG_CAPABILITY.getCapabilityServiceName(address));
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            AddHandler.INSTANCE.performRuntime(context, operation, model);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        static final AddHandler INSTANCE = new AddHandler();

        private AddHandler() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            PathAddress hostAddress = address.getParent();
            PathAddress serverAddress = hostAddress.getParent();
            String worker = AccessLogDefinition.WORKER.resolveModelAttribute(context, model).asString();
            ModelNode properties = METADATA.resolveModelAttribute(context, model);
            LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
            if (properties.isDefined()) {
                for (Property property : properties.asPropertyList()) {
                    metadata.put(property.getName(), property.getValue().asString());
                }
            }
            Predicate predicate = null;
            ModelNode predicateNode = AccessLogDefinition.PREDICATE.resolveModelAttribute(context, model);
            if (predicateNode.isDefined()) {
                predicate = Predicates.parse((String)predicateNode.asString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            boolean includeHostName = INCLUDE_HOST_NAME.resolveModelAttribute(context, model).asBoolean();
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(CONSOLE_ACCESS_LOG_CAPABILITY.getCapabilityServiceName(address));
            Supplier hostSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName}));
            Supplier workerSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.io.worker", XnioWorker.class, new String[]{worker}));
            Collection<AccessLogAttribute> attributes = this.parseAttributes(context, model);
            EventLoggerService service = new EventLoggerService(attributes, predicate, metadata, includeHostName, hostSupplier, workerSupplier);
            serviceBuilder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private Collection<AccessLogAttribute> parseAttributes(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> attributes = new ArrayList<AccessLogAttribute>();
            ModelNode attributesModel = ExchangeAttributeDefinitions.ATTRIBUTES.resolveModelAttribute(context, model);
            for (AttributeDefinition valueType : ExchangeAttributeDefinitions.ATTRIBUTES.getValueTypes()) {
                attributes.addAll(ExchangeAttributeDefinitions.resolveAccessLogAttribute(valueType, context, attributesModel));
            }
            return attributes;
        }
    }
}

