/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import javax.transaction.Synchronization;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;

public class LocalInvalidationSynchronization
implements Synchronization {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(LocalInvalidationSynchronization.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Object lockOwner;
    private final PutFromLoadValidator validator;
    private final Object key;

    public LocalInvalidationSynchronization(PutFromLoadValidator validator, Object key, Object lockOwner) {
        assert (lockOwner != null);
        this.validator = validator;
        this.key = key;
        this.lockOwner = lockOwner;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (trace) {
            log.tracef("After completion callback with status %d", status);
        }
        this.validator.endInvalidatingKey(this.lockOwner, this.key, status == 3 || status == 8);
    }
}

