/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class SecureHashProcessor
implements HashProcessor {
    private DefaultSensitiveStringCodec codec;

    public SecureHashProcessor(DefaultSensitiveStringCodec codec) {
        this.codec = codec;
    }

    @Override
    public String hash(String plainText) throws Exception {
        return PasswordMaskingUtil.wrap(this.codec.encode(plainText));
    }

    @Override
    public boolean compare(char[] inputValue, String storedValue) {
        String storedHash = storedValue.substring(4, storedValue.length() - 1);
        return this.codec.verify(inputValue, storedHash);
    }
}

