/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class BaseHibernateSearchLogger_$logger
extends DelegatingBasicLogger
implements BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BaseHibernateSearchLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public BaseHibernateSearchLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final void illegalObjectRetrievedFromMessage(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    @Override
    public final AssertionFailure unknownResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    @Override
    public final SearchException unsupportedFacetRangeParameter(String type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    @Override
    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String fieldName, Class<?> fieldBridgeClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), fieldName, fieldBridgeClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    @Override
    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier entityName, String fieldName, Class<?> tokenType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(entityName), fieldName, tokenType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    @Override
    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String providerClassName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), providerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

