/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remotingjmx.RemotingConnectorServer;
import org.jboss.remotingjmx.Util;
import org.jboss.remotingjmx.VersionedConectionFactory;
import org.jboss.remotingjmx.VersionedConnection;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.ElytronXmlParser;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

class RemotingConnector
implements JMXConnector {
    private static final Logger log = Logger.getLogger(RemotingConnectorServer.class);
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final JMXServiceURL serviceUrl;
    private final Map<String, ?> environment;
    private Endpoint endpoint;
    private Connection connection;
    private ConnectorState state = ConnectorState.UNUSED;
    private Channel channel;
    private VersionedConnection versionedConnection;
    private ShutDownHook shutDownHook;

    RemotingConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        this.serviceUrl = serviceURL;
        this.environment = Collections.unmodifiableMap(environment);
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        try {
            this.internalConnect(env);
        }
        catch (Exception e) {
            this.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private synchronized void internalConnect(Map<String, ?> env) throws IOException {
        IoFuture futureChannel;
        IoFuture.Status result;
        switch (this.state) {
            case CLOSED: {
                throw new IOException("Connector already closed.");
            }
            case OPEN: {
                return;
            }
        }
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("connect(");
            if (env != null) {
                for (String key : env.keySet()) {
                    Object current = env.get(key);
                    if (current instanceof String[]) {
                        String[] temp = (String[])current;
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("[username=").append(temp[0]).append(",password=").append(temp[1]).append("]");
                        current = sb2;
                    }
                    sb.append("{").append(key).append(",").append(String.valueOf(current)).append("}");
                }
            } else {
                sb.append("null");
            }
            sb.append(")");
            log.trace((Object)sb.toString());
        }
        HashMap combinedEnvironment = new HashMap(this.environment);
        if (env != null) {
            for (String key : env.keySet()) {
                combinedEnvironment.put(key, env.get(key));
            }
        }
        Connection connection = this.internalRemotingConnect(combinedEnvironment);
        String serviceName = this.serviceUrl.getURLPath();
        if ((serviceName.startsWith("/") || serviceName.startsWith(";")) && (serviceName = serviceName.substring(1)).contains("?")) {
            serviceName = serviceName.substring(0, serviceName.indexOf(63));
        }
        if (serviceName.length() == 0) {
            serviceName = "jmx";
        }
        if ((result = (futureChannel = connection.openChannel(serviceName, OptionMap.EMPTY)).await((long)Util.getTimeoutValue(Util.Timeout.CHANNEL, combinedEnvironment).intValue(), TimeUnit.SECONDS)) != IoFuture.Status.DONE) {
            if (result == IoFuture.Status.FAILED) {
                throw futureChannel.getException();
            }
            throw new IOException("Operation failed with status " + result);
        }
        this.channel = (Channel)futureChannel.get();
        this.versionedConnection = VersionedConectionFactory.createVersionedConnection(this.channel, env, this.serviceUrl);
        this.state = ConnectorState.OPEN;
        this.shutDownHook = new ShutDownHook();
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    private Connection internalRemotingConnect(Map<String, ?> env) throws IOException {
        Object list;
        AuthenticationContext captured;
        if (env.containsKey(Connection.class.getName())) {
            return (Connection)env.get(Connection.class.getName());
        }
        this.endpoint = Endpoint.builder().setEndpointName("endpoint").build();
        HashSet<String> disabledMechanisms = new HashSet<String>();
        URI uri = Util.convert(this.serviceUrl);
        Object authConfig = env.get("wildfly.config.url");
        URI authConfigUri = null;
        if (authConfig != null) {
            authConfigUri = authConfig instanceof URI ? (URI)authConfig : URI.create(authConfig.toString());
        }
        if (authConfigUri == null) {
            captured = AuthenticationContext.captureCurrent();
        } else {
            try {
                captured = (AuthenticationContext)ElytronXmlParser.parseAuthenticationClientConfiguration(authConfigUri).create();
            }
            catch (GeneralSecurityException | ConfigXMLParseException e) {
                throw new IOException("Failed to parse authentication configuration " + authConfig, e);
            }
        }
        AuthenticationConfiguration mergedConfiguration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, captured);
        SSLContext tempContext = null;
        try {
            tempContext = AUTH_CONFIGURATION_CLIENT.getSSLContext(uri, captured);
        }
        catch (GeneralSecurityException e) {
            log.trace((Object)"No SSLContext available", (Throwable)e);
        }
        CallbackHandler handler = (CallbackHandler)env.get(CallbackHandler.class.getName());
        if (handler != null) {
            mergedConfiguration = mergedConfiguration.useCallbackHandler(handler);
        } else if (env.containsKey("jmx.remote.credentials")) {
            String[] credentials = (String[])env.get("jmx.remote.credentials");
            mergedConfiguration = mergedConfiguration.useName(credentials[0]).usePassword(credentials[1]).useRealm(null);
            disabledMechanisms.add("JBOSS-LOCAL-USER");
        }
        if (env.containsKey("org.jboss.remoting-jmx.excluded-sasl-mechanisms") && (list = env.get("org.jboss.remoting-jmx.excluded-sasl-mechanisms")) != null) {
            String[] mechanisms = list instanceof String[] ? (String[])list : list.toString().split(",");
            disabledMechanisms.addAll(Arrays.asList(mechanisms));
        }
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, mergedConfiguration);
        SSLContext sslContext = tempContext;
        context = sslContext != null ? context.withSsl(MatchRule.ALL, () -> sslContext) : context;
        IoFuture futureConnection = this.endpoint.connect(Util.convert(this.serviceUrl), this.getOptionMap(disabledMechanisms), context);
        IoFuture.Status result = futureConnection.await((long)Util.getTimeoutValue(Util.Timeout.CONNECTION, env).intValue(), TimeUnit.SECONDS);
        if (result != IoFuture.Status.DONE) {
            if (result == IoFuture.Status.FAILED) {
                throw futureConnection.getException();
            }
            throw new IOException("Operation failed with status " + result);
        }
        this.connection = (Connection)futureConnection.get();
        return this.connection;
    }

    private OptionMap getOptionMap(Set<String> disabledMechanisms) {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        ArrayList<Property> tempProperties = new ArrayList<Property>(1);
        tempProperties.add(Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true"));
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(tempProperties));
        builder.set(Options.SSL_ENABLED, true);
        builder.set(Options.SSL_STARTTLS, true);
        if (disabledMechanisms != null && disabledMechanisms.size() > 0) {
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of(disabledMechanisms));
        }
        return builder.getMap();
    }

    private void verifyConnected() throws IOException {
        if (this.state == ConnectorState.CLOSED) {
            throw new IOException("Connector already closed.");
        }
        if (this.versionedConnection == null) {
            throw new IOException("Connector not connected.");
        }
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        log.trace((Object)"getMBeanServerConnection()");
        return this.getMBeanServerConnection(null);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        log.trace((Object)"getMBeanServerConnection(Subject)");
        this.verifyConnected();
        return this.versionedConnection.getMBeanServerConnection(delegationSubject);
    }

    @Override
    public synchronized void close() throws IOException {
        log.trace((Object)"close()");
        switch (this.state) {
            case CLOSED: 
            case UNUSED: {
                return;
            }
            case OPEN: {
                this.state = ConnectorState.CLOSED;
            }
        }
        ShutDownHook shutDownHook = this.shutDownHook;
        if (shutDownHook != null) {
            Runtime.getRuntime().removeShutdownHook(shutDownHook);
            this.shutDownHook = null;
        }
        this.safeClose(this.versionedConnection);
        this.safeClose(this.channel);
        this.safeClose((Closeable)this.connection);
        this.safeClose((Closeable)this.endpoint);
    }

    private void safeClose(Channel channel) {
        if (channel != null) {
            try {
                channel.writeShutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.safeClose((Closeable)channel);
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        log.trace((Object)"addConnectionNotificationListener()");
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        log.trace((Object)"removeConnectionNotificationListener()");
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        log.trace((Object)"removeConnectionNotificationListener()");
    }

    @Override
    public String getConnectionId() throws IOException {
        log.trace((Object)"getConnectionId()");
        this.verifyConnected();
        String connectionId = this.versionedConnection.getConnectionId();
        log.debugf("Our connection id is '%s'", (Object)connectionId);
        return connectionId;
    }

    private static enum ConnectorState {
        UNUSED,
        OPEN,
        CLOSED;

    }

    private class ShutDownHook
    extends Thread {
        private ShutDownHook() {
            super(new Runnable(){

                @Override
                public void run() {
                    if (RemotingConnector.this.state == ConnectorState.OPEN) {
                        try {
                            RemotingConnector.this.shutDownHook = null;
                            RemotingConnector.this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

