/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.fork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class ForkProtocolStack
extends ProtocolStack {
    protected Address local_addr;
    protected final String fork_stack_id;
    protected final ConcurrentMap<String, JChannel> fork_channels = new ConcurrentHashMap<String, JChannel>();
    protected UnknownForkHandler unknownForkHandler;
    protected final List<Protocol> protocols;
    protected int inits;
    protected int connects;

    public ForkProtocolStack(UnknownForkHandler unknownForkHandler, List<Protocol> protocols, String fork_stack_id) {
        this.unknownForkHandler = unknownForkHandler;
        this.fork_stack_id = fork_stack_id;
        this.protocols = new ArrayList<Protocol>(protocols != null ? protocols.size() : 0);
        if (protocols != null) {
            for (int i = protocols.size() - 1; i >= 0; --i) {
                this.protocols.add(protocols.get(i));
            }
        }
    }

    public ConcurrentMap<String, JChannel> getForkChannels() {
        return this.fork_channels;
    }

    public JChannel get(String fork_channel_id) {
        return (JChannel)this.fork_channels.get(fork_channel_id);
    }

    public JChannel putIfAbsent(String id, JChannel fc) {
        return this.fork_channels.putIfAbsent(id, fc);
    }

    public void remove(String fork_channel_id) {
        this.fork_channels.remove(fork_channel_id);
    }

    public synchronized int getInits() {
        return this.inits;
    }

    public synchronized int getConnects() {
        return this.connects;
    }

    public void setUnknownForkHandler(UnknownForkHandler ufh) {
        this.unknownForkHandler = ufh;
    }

    public UnknownForkHandler getUnknownForkHandler() {
        return this.unknownForkHandler;
    }

    @Override
    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        return this.down_prot.down(msg);
    }

    public void setLocalAddress(Address addr) {
        if (Objects.equals(this.local_addr, addr)) {
            return;
        }
        this.local_addr = addr;
        this.down_prot.down(new Event(8, addr));
    }

    @Override
    public List<Protocol> getProtocols() {
        return new ArrayList<Protocol>(this.protocols);
    }

    public synchronized ForkProtocolStack incrInits() {
        ++this.inits;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public synchronized void startStack() throws Exception {
        if (++this.connects == 1) {
            super.startStack();
        }
    }

    @Override
    public synchronized void stopStack(String cluster) {
        if (--this.connects == 0) {
            super.stopStack(cluster);
        }
    }

    @Override
    public synchronized void destroy() {
        if (--this.inits == 0) {
            super.destroy();
            this.protocols.clear();
            FORK fork = (FORK)this.findProtocol((Class<? extends Protocol>)FORK.class);
            fork.remove(this.fork_stack_id);
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                for (JChannel ch : this.fork_channels.values()) {
                    ch.up(evt);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public Object up(Message msg) {
        FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
        if (hdr == null) {
            return null;
        }
        String forkId = hdr.getForkChannelId();
        if (forkId == null) {
            throw new IllegalArgumentException("header has a null fork_channel_id");
        }
        JChannel fork_channel = this.get(forkId);
        if (fork_channel == null) {
            return this.unknownForkHandler.handleUnknownForkChannel(msg, forkId);
        }
        return fork_channel.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        List list;
        HashMap<String, List> map = new HashMap<String, List>();
        for (Message message : batch) {
            FORK.ForkHeader hdr = (FORK.ForkHeader)message.getHeader(FORK.ID);
            if (hdr == null) continue;
            batch.remove(message);
            list = map.computeIfAbsent(hdr.getForkChannelId(), k -> new ArrayList());
            list.add(message);
        }
        for (Map.Entry entry : map.entrySet()) {
            String fork_channel_id = (String)entry.getKey();
            list = (List)entry.getValue();
            JChannel fork_channel = this.get(fork_channel_id);
            if (fork_channel == null) {
                for (Message m : list) {
                    this.unknownForkHandler.handleUnknownForkChannel(m, fork_channel_id);
                }
                continue;
            }
            MessageBatch mb = new MessageBatch(batch.dest(), batch.sender(), batch.clusterName(), batch.multicast(), list);
            try {
                fork_channel.up(mb);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedPassingUpBatch"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }
}

