/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.stack.IpAddress;

class DefaultDNSResolver
implements DNSResolver {
    private static final Pattern SRV_REGEXP = Pattern.compile("\\d+ \\d+ (\\d+) ([\\w+\\.-]+)");
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final DirContext dnsContext;

    DefaultDNSResolver(DirContext context) {
        this.dnsContext = context;
    }

    public DefaultDNSResolver(String dnsContextFactory, String dnsAddress) throws NamingException {
        log.trace("initializing DNS Context with factory: %s and url: %s", dnsContextFactory, dnsAddress);
        Properties env = new Properties();
        env.put("java.naming.factory.initial", dnsContextFactory);
        if (dnsAddress != null) {
            env.put("java.naming.provider.url", "dns://" + dnsAddress);
        }
        this.dnsContext = new InitialDirContext(env);
    }

    @Override
    public void close() {
        try {
            this.dnsContext.close();
        }
        catch (NamingException e) {
            log.warn(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public List<Address> resolveIps(String dnsQuery, DNSResolver.DNSRecordType recordType) {
        log.trace("resolving DNS query: %s of a type: %s", dnsQuery, recordType.toString());
        switch (recordType) {
            case A: {
                return this.resolveAEntries(dnsQuery);
            }
            case SRV: {
                return this.resolveSRVEntries(dnsQuery);
            }
        }
        throw new IllegalStateException("Not implemented");
    }

    protected DirContext getDnsContext() {
        return this.dnsContext;
    }

    protected List<Address> resolveSRVEntries(String dnsQuery) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            Attributes attributes = this.dnsContext.getAttributes(dnsQuery, new String[]{DNSResolver.DNSRecordType.SRV.toString()});
            if (attributes != null && attributes.getAll().hasMoreElements()) {
                NamingEnumeration<?> namingEnumeration = attributes.get(DNSResolver.DNSRecordType.SRV.toString()).getAll();
                while (namingEnumeration.hasMoreElements()) {
                    try {
                        String srvEntry = namingEnumeration.nextElement().toString();
                        Matcher matcher = SRV_REGEXP.matcher(srvEntry);
                        if (!matcher.find()) continue;
                        String srcPort = matcher.group(1);
                        String srcDNSRecord = matcher.group(2);
                        addresses.addAll(DefaultDNSResolver.resolveAEntries(srcDNSRecord, srcPort));
                    }
                    catch (Exception e) {
                        log.trace("non critical DNS resolution error", e);
                    }
                }
            }
        }
        catch (NamingException ex) {
            log.trace("no DNS records for query %s, ex: %s", dnsQuery, ex.getMessage());
        }
        return addresses;
    }

    protected List<Address> resolveAEntries(String dnsQuery) {
        return DefaultDNSResolver.resolveAEntries(dnsQuery, "0");
    }

    protected static List<Address> resolveAEntries(String dnsQuery, String srcPort) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            InetAddress[] inetAddresses;
            for (InetAddress address : inetAddresses = InetAddress.getAllByName(dnsQuery)) {
                addresses.add(new IpAddress(address, Integer.parseInt(srcPort)));
            }
        }
        catch (UnknownHostException ex) {
            log.trace("failed to resolve query %s, ex: %s", dnsQuery, ex.getMessage());
        }
        return addresses;
    }
}

