/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchPortRule
extends MatchRule {
    private final int port;

    MatchPortRule(MatchRule parent, int port) {
        super(parent);
        this.port = port;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        return uri.getPort() == this.port && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchPortRule(newParent, this.port);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return other.getMatchPort() == this.port && this.parentHalfEqual(other);
    }

    @Override
    public int getMatchPort() {
        return this.port;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)7919, (int)this.port);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("port=").append(this.port).append(',');
    }
}

