/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.GSSManagerFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

abstract class HttpAuthMethod {
    static final String EMPTY_STRING = "";
    static final String SCHEMA_NAME_SEPARATOR = " ";
    protected final Type type;

    static HttpAuthMethod scanResponse(HttpConnection conn, Collection<Type> ignoreTypes) {
        Map<String, List<String>> headers = conn.getHeaderFields();
        HttpAuthMethod authentication = Type.NONE.method(EMPTY_STRING);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (!"WWW-Authenticate".equalsIgnoreCase(entry.getKey())) continue;
            if (entry.getValue() == null) break;
            for (String value : entry.getValue()) {
                if (value == null || value.length() == 0) continue;
                String[] valuePart = value.split(SCHEMA_NAME_SEPARATOR, 2);
                try {
                    Type methodType = Type.valueOf(valuePart[0].toUpperCase(Locale.ROOT));
                    if (ignoreTypes != null && ignoreTypes.contains((Object)methodType) || authentication.getType().compareTo(methodType) >= 0) continue;
                    String param = valuePart.length == 1 ? EMPTY_STRING : valuePart[1];
                    authentication = methodType.method(param);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return authentication;
    }

    protected HttpAuthMethod(Type type) {
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean authorize(URIish uri, CredentialsProvider credentialsProvider) {
        String password;
        String username;
        if (credentialsProvider != null) {
            CredentialItem.Username u = new CredentialItem.Username();
            CredentialItem.Password p = new CredentialItem.Password();
            if (!credentialsProvider.supports(u, p) || !credentialsProvider.get(uri, u, p)) return false;
            username = u.getValue();
            char[] v = p.getValue();
            password = v == null ? null : new String(p.getValue());
            p.clear();
        } else {
            username = uri.getUser();
            password = uri.getPass();
        }
        if (username == null) return false;
        this.authorize(username, password);
        return true;
    }

    abstract void authorize(String var1, String var2);

    abstract void configureRequest(HttpConnection var1) throws IOException;

    public Type getType() {
        return this.type;
    }

    private static class Basic
    extends HttpAuthMethod {
        private String user;
        private String pass;

        public Basic() {
            super(Type.BASIC);
        }

        @Override
        void authorize(String username, String password) {
            this.user = username;
            this.pass = password;
        }

        @Override
        void configureRequest(HttpConnection conn) throws IOException {
            String ident = String.valueOf(this.user) + ":" + this.pass;
            String enc = Base64.encodeBytes(ident.getBytes(Constants.CHARSET));
            conn.setRequestProperty("Authorization", String.valueOf(this.type.getSchemeName()) + HttpAuthMethod.SCHEMA_NAME_SEPARATOR + enc);
        }
    }

    private static class Digest
    extends HttpAuthMethod {
        private static final SecureRandom PRNG = new SecureRandom();
        private final Map<String, String> params;
        private int requestCount;
        private String user;
        private String pass;
        private static final char[] LHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        Digest(String hdr) {
            super(Type.DIGEST);
            this.params = Digest.parse(hdr);
            String qop = this.params.get("qop");
            if ("auth".equals(qop)) {
                byte[] bin = new byte[8];
                PRNG.nextBytes(bin);
                this.params.put("cnonce", Base64.encodeBytes(bin));
            }
        }

        @Override
        void authorize(String username, String password) {
            this.user = username;
            this.pass = password;
        }

        @Override
        void configureRequest(HttpConnection conn) throws IOException {
            String response;
            String nc;
            LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
            String realm = this.params.get("realm");
            String nonce = this.params.get("nonce");
            String cnonce = this.params.get("cnonce");
            String uri = Digest.uri(conn.getURL());
            String qop = this.params.get("qop");
            String method = conn.getRequestMethod();
            String A1 = String.valueOf(this.user) + ":" + realm + ":" + this.pass;
            String A2 = String.valueOf(method) + ":" + uri;
            r.put("username", this.user);
            r.put("realm", realm);
            r.put("nonce", nonce);
            r.put("uri", uri);
            if ("auth".equals(qop)) {
                nc = String.format("%08x", ++this.requestCount);
                response = Digest.KD(Digest.H(A1), String.valueOf(nonce) + ":" + nc + ":" + cnonce + ":" + qop + ":" + Digest.H(A2));
            } else {
                nc = null;
                response = Digest.KD(Digest.H(A1), String.valueOf(nonce) + ":" + Digest.H(A2));
            }
            r.put("response", response);
            if (this.params.containsKey("algorithm")) {
                r.put("algorithm", "MD5");
            }
            if (cnonce != null && qop != null) {
                r.put("cnonce", cnonce);
            }
            if (this.params.containsKey("opaque")) {
                r.put("opaque", this.params.get("opaque"));
            }
            if (qop != null) {
                r.put("qop", qop);
            }
            if (nc != null) {
                r.put("nc", nc);
            }
            StringBuilder v = new StringBuilder();
            for (Map.Entry e : r.entrySet()) {
                if (v.length() > 0) {
                    v.append(", ");
                }
                v.append((String)e.getKey());
                v.append('=');
                v.append('\"');
                v.append((String)e.getValue());
                v.append('\"');
            }
            conn.setRequestProperty("Authorization", String.valueOf(this.type.getSchemeName()) + HttpAuthMethod.SCHEMA_NAME_SEPARATOR + v);
        }

        private static String uri(URL u) {
            StringBuilder r = new StringBuilder();
            r.append(u.getProtocol());
            r.append("://");
            r.append(u.getHost());
            if (!(u.getPort() <= 0 || u.getPort() == 80 && "http".equals(u.getProtocol()) || u.getPort() == 443 && "https".equals(u.getProtocol()))) {
                r.append(':').append(u.getPort());
            }
            r.append(u.getPath());
            if (u.getQuery() != null) {
                r.append('?').append(u.getQuery());
            }
            return r.toString();
        }

        private static String H(String data) {
            MessageDigest md = Digest.newMD5();
            md.update(data.getBytes(Constants.CHARSET));
            return Digest.LHEX(md.digest());
        }

        private static String KD(String secret, String data) {
            MessageDigest md = Digest.newMD5();
            md.update(secret.getBytes(Constants.CHARSET));
            md.update((byte)58);
            md.update(data.getBytes(Constants.CHARSET));
            return Digest.LHEX(md.digest());
        }

        private static MessageDigest newMD5() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No MD5 available", e);
            }
        }

        private static String LHEX(byte[] bin) {
            StringBuilder r = new StringBuilder(bin.length * 2);
            int i = 0;
            while (i < bin.length) {
                byte b = bin[i];
                r.append(LHEX[b >>> 4 & 0xF]);
                r.append(LHEX[b & 0xF]);
                ++i;
            }
            return r.toString();
        }

        private static Map<String, String> parse(String auth) {
            HashMap<String, String> p = new HashMap<String, String>();
            int next = 0;
            while (next < auth.length()) {
                String value;
                if (next < auth.length() && auth.charAt(next) == ',') {
                    ++next;
                }
                while (next < auth.length() && Character.isWhitespace(auth.charAt(next))) {
                    ++next;
                }
                int eq = auth.indexOf(61, next);
                if (eq < 0 || eq + 1 == auth.length()) {
                    return Collections.emptyMap();
                }
                String name = auth.substring(next, eq);
                if (auth.charAt(eq + 1) == '\"') {
                    int dq = auth.indexOf(34, eq + 2);
                    if (dq < 0) {
                        return Collections.emptyMap();
                    }
                    value = auth.substring(eq + 2, dq);
                    next = dq + 1;
                } else {
                    int space = auth.indexOf(32, eq + 1);
                    int comma = auth.indexOf(44, eq + 1);
                    if (space < 0) {
                        space = auth.length();
                    }
                    if (comma < 0) {
                        comma = auth.length();
                    }
                    int e = Math.min(space, comma);
                    value = auth.substring(eq + 1, e);
                    next = e + 1;
                }
                p.put(name, value);
            }
            return p;
        }
    }

    private static class Negotiate
    extends HttpAuthMethod {
        private static final GSSManagerFactory GSS_MANAGER_FACTORY = GSSManagerFactory.detect();
        private static final Oid OID;
        private final byte[] prevToken;

        static {
            try {
                OID = new Oid("1.3.6.1.5.5.2");
            }
            catch (GSSException e) {
                throw new Error("Cannot create NEGOTIATE oid.", e);
            }
        }

        public Negotiate(String hdr) {
            super(Type.NEGOTIATE);
            this.prevToken = Base64.decode(hdr);
        }

        @Override
        void authorize(String user, String pass) {
        }

        @Override
        void configureRequest(HttpConnection conn) throws IOException {
            GSSManager gssManager = GSS_MANAGER_FACTORY.newInstance(conn.getURL());
            String host = conn.getURL().getHost();
            String peerName = "HTTP@" + host.toLowerCase(Locale.ROOT);
            try {
                GSSName gssName = gssManager.createName(peerName, GSSName.NT_HOSTBASED_SERVICE);
                GSSContext context = gssManager.createContext(gssName, OID, null, 0);
                context.requestCredDeleg(true);
                byte[] token = context.initSecContext(this.prevToken, 0, this.prevToken.length);
                conn.setRequestProperty("Authorization", String.valueOf(this.getType().getSchemeName()) + HttpAuthMethod.SCHEMA_NAME_SEPARATOR + Base64.encodeBytes(token));
            }
            catch (GSSException e) {
                throw new IOException(e);
            }
        }
    }

    private static class None
    extends HttpAuthMethod {
        static final None INSTANCE = new None();

        public None() {
            super(Type.NONE);
        }

        @Override
        void authorize(String user, String pass) {
        }

        @Override
        void configureRequest(HttpConnection conn) throws IOException {
        }
    }

    public static enum Type {
        NONE{

            @Override
            public HttpAuthMethod method(String hdr) {
                return None.INSTANCE;
            }

            @Override
            public String getSchemeName() {
                return "None";
            }
        }
        ,
        BASIC{

            @Override
            public HttpAuthMethod method(String hdr) {
                return new Basic();
            }

            @Override
            public String getSchemeName() {
                return "Basic";
            }
        }
        ,
        DIGEST{

            @Override
            public HttpAuthMethod method(String hdr) {
                return new Digest(hdr);
            }

            @Override
            public String getSchemeName() {
                return "Digest";
            }
        }
        ,
        NEGOTIATE{

            @Override
            public HttpAuthMethod method(String hdr) {
                return new Negotiate(hdr);
            }

            @Override
            public String getSchemeName() {
                return "Negotiate";
            }
        };


        public abstract HttpAuthMethod method(String var1);

        public abstract String getSchemeName();
    }
}

