/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.singleton.SingletonRequirement;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyServiceConfigurator;

public class SingletonPolicyServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        ServiceConfigurator configurator = new SingletonPolicyServiceConfigurator(address).configure(context, model);
        configurator.build(target).install();
        new AliasServiceBuilder(SingletonPolicyResourceDefinition.Capability.LEGACY_POLICY.getServiceName(address), configurator.getServiceName(), SingletonRequirement.SINGLETON_POLICY.getType()).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (SingletonPolicyResourceDefinition.Capability capability : EnumSet.allOf(SingletonPolicyResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
    }
}

