/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.view;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.faces.component.UIComponent;
import javax.faces.component.UIImportConstants;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class ViewMetadata {
    public abstract String getViewId();

    public abstract UIViewRoot createMetadataView(FacesContext var1);

    public static Collection<UIViewParameter> getViewParameters(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIViewParameter.class);
    }

    public static Collection<UIViewAction> getViewActions(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIViewAction.class);
    }

    public static Collection<UIImportConstants> getImportConstants(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIImportConstants.class);
    }

    public static boolean hasMetadata(UIViewRoot root) {
        return ViewMetadata.getMetadataFacet(root).map(m -> m.getChildCount() > 0).orElse(false);
    }

    private static <C extends UIComponent> List<C> getMetadataChildren(UIViewRoot root, Class<C> type) {
        return ViewMetadata.getMetadataFacet(root).map(m -> m.getChildren()).orElseGet(Collections::emptyList).stream().filter(c -> type.isInstance(c)).collect(Collectors.toList());
    }

    private static Optional<UIComponent> getMetadataFacet(UIViewRoot root) {
        return Optional.ofNullable(root.getFacet("javax_faces_metadata"));
    }
}

