/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.util.logging.LogFactory;

class MySQLTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(MySQLTableManager.class, Log.class);

    MySQLTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
        this.identifierQuoteString = "`";
    }

    @Override
    public int getFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = this.metaData.isSegmentedDisabled() ? String.format("%1$s ON DUPLICATE KEY UPDATE %2$s = VALUES(%2$s), %3$s = VALUES(%3$s)", this.getInsertRowSql(), this.config.dataColumnName(), this.config.timestampColumnName()) : String.format("%1$s ON DUPLICATE KEY UPDATE %2$s = VALUES(%2$s), %3$s = VALUES(%3$s), %4$s = VALUES(%4$s)", this.getInsertRowSql(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.segmentColumnName());
        }
        return this.upsertRowSql;
    }
}

