/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class LogFileResourceDefinition
extends SimpleResourceDefinition {
    static final AccessConstraintDefinition VIEW_SERVER_LOGS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("logging", "view-server-logs", false, false, false));
    static final String NAME = "log-file";
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleAttributeDefinition FILE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"file-size", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime()).setAllowExpression(false)).build();
    private static final SimpleAttributeDefinition LAST_MODIFIED_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"last-modified-time", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime()).setAllowExpression(false)).build();
    private static final SimpleAttributeDefinition LAST_MODIFIED_TIMESTAMP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"last-modified-timestamp", (ModelType)ModelType.STRING, (boolean)false).setStorageRuntime()).setAllowExpression(false)).build();
    private static final SimpleAttributeDefinition STREAM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"stream", (ModelType)ModelType.STRING).setStorageRuntime()).setRequired(false)).build();
    private static final SimpleAttributeDefinition LINES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"lines", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    private static final SimpleAttributeDefinition SKIP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"skip", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setValidator((ParameterValidator)new IntRangeValidator(0, true))).build();
    private static final SimpleAttributeDefinition TAIL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"tail", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    private static final SimpleOperationDefinition READ_LOG_FILE = new SimpleOperationDefinitionBuilder("read-log-file", LoggingExtension.getResourceDescriptionResolver(new String[0])).addAccessConstraint(VIEW_SERVER_LOGS).setParameters(new AttributeDefinition[]{CommonAttributes.ENCODING, LINES, SKIP, TAIL}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    private static final PathElement LOG_FILE_PATH = PathElement.pathElement((String)"log-file");
    private final PathManager pathManager;

    LogFileResourceDefinition(PathManager pathManager) {
        super(new SimpleResourceDefinition.Parameters(LOG_FILE_PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setRuntime().setAccessConstraints(new AccessConstraintDefinition[]{VIEW_SERVER_LOGS}));
        assert (pathManager != null) : "PathManager cannot be null";
        this.pathManager = pathManager;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_LOG_FILE, (OperationStepHandler)new ReadLogFileOperation(this.pathManager));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)FILE_SIZE, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(Path path, ModelNode model) throws IOException {
                model.set(Files.size(path));
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_MODIFIED_TIME, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(Path path, ModelNode model) throws IOException {
                model.set(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAST_MODIFIED_TIMESTAMP, (OperationStepHandler)new ReadAttributeOperationStepHandler(){

            @Override
            protected void updateModel(Path path, ModelNode model) throws IOException {
                SimpleDateFormat sdf = new SimpleDateFormat(LogFileResourceDefinition.ISO_8601_FORMAT);
                model.set(sdf.format(new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis())));
            }
        });
        OperationStepHandler streamHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String name = context.getCurrentAddressValue();
                String logDir = LogFileResourceDefinition.this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
                LogFileResourceDefinition.validateFile(context, logDir, name);
                Path path = Paths.get(logDir, name);
                try {
                    String uuid = context.attachResultStream("text/plain", Files.newInputStream(path, new OpenOption[0]));
                    context.getResult().set(uuid);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)STREAM, streamHandler);
    }

    private static void validateFile(OperationContext context, String logDir, final String fileName) throws OperationFailedException {
        context.readResource(PathAddress.EMPTY_ADDRESS);
        final Path dir = Paths.get(logDir, new String[0]);
        final AtomicBoolean found = new AtomicBoolean();
        try {
            Files.walkFileTree(dir, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativeFile = dir.relativize(file);
                    if (fileName.equals(relativeFile.toString())) {
                        found.set(true);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw LoggingLogger.ROOT_LOGGER.failedToReadLogFile(e, fileName);
        }
        if (!found.get()) {
            throw LoggingLogger.ROOT_LOGGER.readNotAllowed(fileName);
        }
    }

    static final class LifoFileInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private final long len;
        private long start;
        private long end;
        private long pos;

        LifoFileInputStream(File file) throws IOException {
            this.raf = new RandomAccessFile(file, "r");
            this.start = this.len = this.raf.length();
            this.pos = this.end = this.len;
        }

        private void positionFile() throws IOException {
            this.end = this.start;
            if (this.end == 0L) {
                this.end = -1L;
                this.start = -1L;
                this.pos = -1L;
                return;
            }
            long filePointer = this.start - 1L;
            while (--filePointer >= 0L) {
                this.raf.seek(filePointer);
                byte readByte = this.raf.readByte();
                if (readByte != 10 || filePointer == this.len - 1L) continue;
                break;
            }
            this.pos = this.start = filePointer + 1L;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.end) {
                this.raf.seek(this.pos++);
                return this.raf.readByte();
            }
            if (this.pos < 0L) {
                return -1;
            }
            this.positionFile();
            return this.read();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }

    static class ReadLogFileOperation
    implements OperationStepHandler {
        private final PathManager pathManager;

        private ReadLogFileOperation(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String fileName = context.getCurrentAddressValue();
            String logDir = this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            LogFileResourceDefinition.validateFile(context, logDir, fileName);
            for (AttributeDefinition attribute : READ_LOG_FILE.getParameters()) {
                attribute.validateOperation(operation);
            }
            int numberOfLines = LINES.resolveModelAttribute(context, operation).asInt();
            int skip = SKIP.resolveModelAttribute(context, operation).asInt();
            boolean tail = TAIL.resolveModelAttribute(context, operation).asBoolean();
            ModelNode encodingModel = CommonAttributes.ENCODING.resolveModelAttribute(context, operation);
            String encoding = encodingModel.isDefined() ? encodingModel.asString() : null;
            File path = new File(this.pathManager.resolveRelativePathEntry(fileName, "jboss.server.log.dir"));
            if (!path.exists()) {
                throw LoggingLogger.ROOT_LOGGER.logFileNotFound(fileName, "jboss.server.log.dir");
            }
            try {
                List<Object> lines = numberOfLines == 0 ? Collections.emptyList() : this.readLines(path, encoding, tail, skip, numberOfLines);
                ModelNode result = context.getResult().setEmptyList();
                for (String line : lines) {
                    result.add(line);
                }
            }
            catch (IOException e) {
                throw LoggingLogger.ROOT_LOGGER.failedToReadLogFile(e, fileName);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        /*
         * Exception decompiling
         */
        private List<String> readLines(File file, String encoding, boolean tail, int skip, int numberOfLines) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private abstract class ReadAttributeOperationStepHandler
    implements OperationStepHandler {
        private ReadAttributeOperationStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.getResult();
            String name = context.getCurrentAddressValue();
            String logDir = LogFileResourceDefinition.this.pathManager.getPathEntry("jboss.server.log.dir").resolvePath();
            LogFileResourceDefinition.validateFile(context, logDir, name);
            Path path = Paths.get(logDir, name);
            if (Files.notExists(path, new LinkOption[0])) {
                throw LoggingLogger.ROOT_LOGGER.logFileNotFound(name, logDir);
            }
            try {
                this.updateModel(path, model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }

        protected abstract void updateModel(Path var1, ModelNode var2) throws IOException;
    }
}

