/*
 * Decompiled with CFR 0.152.
 */
package org.aesh;

import java.io.IOException;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;

public class AeshRuntimeRunner {
    private Class<? extends Command> command;
    private CommandRuntime runtime;
    private String[] args;

    private AeshRuntimeRunner() {
    }

    public static AeshRuntimeRunner builder() {
        return new AeshRuntimeRunner();
    }

    public AeshRuntimeRunner command(Class<? extends Command> command) {
        this.command = command;
        return this;
    }

    public AeshRuntimeRunner commandRuntime(CommandRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    public AeshRuntimeRunner args(String[] args) {
        this.args = args;
        return this;
    }

    public void execute() {
        if (this.command == null && this.runtime == null) {
            throw new RuntimeException("Command needs to be added");
        }
        try {
            if (this.runtime == null) {
                this.runtime = AeshCommandRuntimeBuilder.builder().commandRegistry(AeshCommandRegistryBuilder.builder().command(this.command).create()).build();
            } else {
                if (this.runtime.getCommandRegistry().getAllCommandNames().isEmpty()) {
                    throw new RuntimeException("Command needs to be added to the registry.");
                }
                if (this.runtime.getCommandRegistry().getAllCommandNames().size() > 1) {
                    throw new RuntimeException("Only one command can be added to the registry.");
                }
            }
            StringBuilder sb = new StringBuilder(this.runtime.getCommandRegistry().getAllCommandNames().iterator().next());
            if (this.args.length > 0) {
                sb.append(" ");
                if (this.args.length == 1) {
                    sb.append(this.args[0]);
                } else {
                    for (String arg : this.args) {
                        if (arg.indexOf(32) >= 0) {
                            sb.append('\"').append(arg).append("\" ");
                            continue;
                        }
                        sb.append(arg).append(' ');
                    }
                }
            }
            this.runtime.executeCommand(sb.toString());
        }
        catch (IOException | InterruptedException | CommandException | CommandNotFoundException | CommandLineParserException | CommandRegistryException | CommandValidatorException | OptionValidatorException e) {
            throw new RuntimeException("Exception while executing command: " + e.getMessage());
        }
    }
}

