/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;

public class QueryConfiguration {
    private final DataSource dataSource;
    private String sql;
    private List<ColumnMapper> columnMappers = new ArrayList<ColumnMapper>();

    QueryConfiguration(String sql, DataSource dataSource, List<ColumnMapper> columnMappers) {
        Assert.checkNotNullParam("sql", sql);
        Assert.checkNotNullParam("dataSource", dataSource);
        Assert.checkNotNullParam("columnMappers", columnMappers);
        this.sql = sql;
        this.dataSource = dataSource;
        this.columnMappers = columnMappers;
    }

    String getSql() {
        return this.sql;
    }

    DataSource getDataSource() {
        return this.dataSource;
    }

    List<ColumnMapper> getColumnMappers() {
        return Collections.unmodifiableList(this.columnMappers);
    }

    <T extends ColumnMapper> List<T> getColumnMappers(Class<T> mapperType) {
        ArrayList<ColumnMapper> attributeMappers = new ArrayList<ColumnMapper>();
        for (ColumnMapper columnMapper : this.columnMappers) {
            if (!mapperType.isInstance(columnMapper)) continue;
            attributeMappers.add((ColumnMapper)mapperType.cast(columnMapper));
        }
        return attributeMappers;
    }
}

