/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.mechanism._private.ElytronMessages;

class ScramUtil {
    private static final byte[] randomCharDictionary;
    static final byte[] CLIENT_KEY_BYTES;
    static final byte[] SERVER_KEY_BYTES;

    ScramUtil() {
    }

    public static byte[] generateNonce(int length, Random random) {
        byte[] chars = new byte[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = randomCharDictionary[random.nextInt(93)];
        }
        return chars;
    }

    public static int parsePosInt(ByteIterator i) {
        int a;
        if (!i.hasNext()) {
            throw ElytronMessages.log.emptyNumber();
        }
        int c = i.next();
        if (c >= 49 && c <= 57) {
            a = c - 48;
        } else {
            throw ElytronMessages.log.invalidNumericCharacter();
        }
        while (i.hasNext()) {
            c = i.next();
            if (c >= 48 && c <= 57) {
                if ((a = (a << 3) + (a << 1) + (c - 48)) >= 0) continue;
                throw ElytronMessages.log.tooBigNumber();
            }
            throw ElytronMessages.log.invalidNumericCharacter();
        }
        return a;
    }

    static void xor(byte[] hash, byte[] input) {
        assert (hash.length == input.length);
        for (int i = 0; i < hash.length; ++i) {
            int n = i;
            hash[n] = (byte)(hash[n] ^ input[i]);
        }
    }

    static {
        int c;
        CLIENT_KEY_BYTES = "Client Key".getBytes(StandardCharsets.UTF_8);
        SERVER_KEY_BYTES = "Server Key".getBytes(StandardCharsets.UTF_8);
        byte[] dict = new byte[93];
        int i = 0;
        for (c = 33; c < 44; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        for (c = 45; c < 127; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        assert (i == dict.length);
        randomCharDictionary = dict;
    }
}

