/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert.acme;

import java.time.Instant;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.security.x500.cert.acme.AcmeException;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");
    public static final ElytronMessages acme = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.x500.cert.acme");

    @Message(id=10016, value="Unable to determine key size")
    public IllegalArgumentException unableToDetermineKeySize();

    @Message(id=10019, value="Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"")
    public IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String var1);

    @Message(id=10029, value="Failed to generate ACME account key pair")
    public IllegalArgumentException acmeAccountKeyPairGenerationFailed(@Cause Exception var1);

    @Message(id=10030, value="No ACME server URL given")
    public IllegalArgumentException noAcmeServerUrlGiven();

    @Message(id=10031, value="Unsupported ACME account signature algorithm \"%s\"")
    public IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(String var1);

    @Message(id=10032, value="Unable to create ACME signature")
    public IllegalArgumentException unableToCreateAcmeSignature(@Cause Exception var1);

    @Message(id=10033, value="Unable to retrieve ACME server directory URLs")
    public AcmeException unableToRetrieveAcmeServerDirectoryUrls(@Cause Exception var1);

    @Message(id=10034, value="No nonce provided by ACME server")
    public AcmeException noNonceProvidedByAcmeServer();

    @Message(id=10035, value="No account location URL provided by ACME server")
    public AcmeException noAccountLocationUrlProvidedByAcmeServer();

    @Message(id=10036, value="Unable to obtain new nonce from ACME server")
    public AcmeException unableToObtainNewNonceFromAcmeServer();

    @Message(id=10037, value="Unable to obtain JSON response from ACME server")
    public AcmeException unableToObtainJsonResponseFromAcmeServer(@Cause Exception var1);

    @Message(id=10038, value="Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"")
    public AcmeException unexpectedResponseCodeFromAcmeServer(int var1, String var2);

    @Message(id=10039, value="Bad ACME replay nonce, maximum retries attempted")
    public AcmeException badAcmeNonce();

    @Message(id=10040, value="Unexpected content type in response from ACME server \"%s\"")
    public AcmeException unexpectedContentTypeFromAcmeServer(String var1);

    @Message(id=10041, value="Invalid content type in response from ACME server")
    public AcmeException invalidContentTypeFromAcmeServer();

    @Message(id=10042, value="Domain name is null")
    public AcmeException domainNameIsNull();

    @Message(id=10043, value="Domain names is empty")
    public AcmeException domainNamesIsEmpty();

    @Message(id=10044, value="No certificate URL provided by ACME server")
    public AcmeException noCertificateUrlProvidedByAcmeServer();

    @Message(id=10045, value="No certificate will be issued by the ACME server")
    public AcmeException noCertificateWillBeIssuedByAcmeServer();

    @Message(id=10046, value="Unable to get encoded form of certificate to be revoked")
    public AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(@Cause Exception var1);

    @Message(id=10047, value="Unable to determine key authorization string")
    public AcmeException unableToDetermineKeyAuthorizationString(@Cause Exception var1);

    @Message(id=10048, value="Challenge response failed validation by the ACME server")
    public AcmeException challengeResponseFailedValidationByAcmeServer();

    @Message(id=10049, value="Unable to download certificate chain from ACME server")
    public AcmeException unableToDownloadCertificateChainFromAcmeServer(@Cause Exception var1);

    @Message(id=10050, value="ACME account does not exist")
    public AcmeException acmeAccountDoesNotExist();

    @Message(id=10051, value="User action required since the ACME server's terms of service have changed, visit \"%s\" for details")
    public AcmeException userActionRequired(String var1);

    @Message(id=10052, value="Rate limit has been exceeded, try again after \"%s\"")
    public AcmeException rateLimitExceededTryAgainLater(Instant var1);

    @Message(id=10053, value="Rate limit has been exceeded")
    public AcmeException rateLimitExceeded();

    @Message(id=10054, value="Resource not supported by the ACME server \"%s\"")
    public AcmeException resourceNotSupportedByAcmeServer(String var1);

    @Message(id=10055, value="Unsupported ACME account public key type \"%s\"")
    public IllegalArgumentException unsupportedAcmeAccountPublicKeyType(String var1);

    @Message(id=10056, value="Unable to determine curve parameter from alg header \"%s\"")
    public IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(String var1);
}

