/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import javax.servlet.ServletContext;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;

@Provider
public class TracerDynamicFeature
implements DynamicFeature {
    @Context
    ServletContext servletContext;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Object tracerObject = this.servletContext.getAttribute("smallrye.opentracing.tracer");
        if (!(tracerObject instanceof Tracer)) {
            TracingLogger.ROOT_LOGGER.noTracerAvailable();
            return;
        }
        Tracer tracer = (Tracer)tracerObject;
        ServerTracingDynamicFeature delegate = new ServerTracingDynamicFeature.Builder(tracer).withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.ClassNameOperationName.newBuilder()).withTraceSerialization(false).build();
        delegate.configure(resourceInfo, context);
    }
}

