/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.TypeEncoding;

public class DynamicDescribedType
implements AMQPType<DescribedType> {
    private final EncoderImpl _encoder;
    private final Map<TypeEncoding, TypeEncoding> _encodings = new HashMap<TypeEncoding, TypeEncoding>();
    private final Object _descriptor;

    public DynamicDescribedType(EncoderImpl encoder, Object descriptor) {
        this._encoder = encoder;
        this._descriptor = descriptor;
    }

    @Override
    public Class<DescribedType> getTypeClass() {
        return DescribedType.class;
    }

    @Override
    public TypeEncoding<DescribedType> getEncoding(DescribedType val) {
        TypeEncoding<Object> underlyingEncoding = this._encoder.getType(val.getDescribed()).getEncoding(val.getDescribed());
        TypeEncoding encoding = this._encodings.get(underlyingEncoding);
        if (encoding == null) {
            encoding = new DynamicDescribedTypeEncoding(underlyingEncoding);
            this._encodings.put(underlyingEncoding, encoding);
        }
        return encoding;
    }

    @Override
    public TypeEncoding<DescribedType> getCanonicalEncoding() {
        return null;
    }

    @Override
    public Collection<TypeEncoding<DescribedType>> getAllEncodings() {
        Collection<TypeEncoding> values = this._encodings.values();
        Collection<TypeEncoding<DescribedType>> unmodifiable = Collections.unmodifiableCollection(values);
        return unmodifiable;
    }

    @Override
    public void write(DescribedType val) {
        TypeEncoding<DescribedType> encoding = this.getEncoding(val);
        encoding.writeConstructor();
        encoding.writeValue(val);
    }

    private class DynamicDescribedTypeEncoding
    implements TypeEncoding {
        private final TypeEncoding _underlyingEncoding;
        private final TypeEncoding _descriptorType;
        private final int _constructorSize;

        public DynamicDescribedTypeEncoding(TypeEncoding underlyingEncoding) {
            this._underlyingEncoding = underlyingEncoding;
            this._descriptorType = DynamicDescribedType.this._encoder.getType(DynamicDescribedType.this._descriptor).getEncoding(DynamicDescribedType.this._descriptor);
            this._constructorSize = 1 + this._descriptorType.getConstructorSize() + this._descriptorType.getValueSize(DynamicDescribedType.this._descriptor) + this._underlyingEncoding.getConstructorSize();
        }

        public AMQPType getType() {
            return DynamicDescribedType.this;
        }

        @Override
        public void writeConstructor() {
            DynamicDescribedType.this._encoder.writeRaw((byte)0);
            this._descriptorType.writeConstructor();
            this._descriptorType.writeValue(DynamicDescribedType.this._descriptor);
            this._underlyingEncoding.writeConstructor();
        }

        @Override
        public int getConstructorSize() {
            return this._constructorSize;
        }

        public void writeValue(Object val) {
            this._underlyingEncoding.writeValue(((DescribedType)val).getDescribed());
        }

        public int getValueSize(Object val) {
            return this._underlyingEncoding.getValueSize(((DescribedType)val).getDescribed());
        }

        @Override
        public boolean isFixedSizeVal() {
            return this._underlyingEncoding.isFixedSizeVal();
        }

        public boolean encodesSuperset(TypeEncoding encoding) {
            return this.getType() == encoding.getType() && this._underlyingEncoding.encodesSuperset(((DynamicDescribedTypeEncoding)encoding)._underlyingEncoding);
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return false;
        }
    }
}

