/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class PrimaryOwnerRouteLocator
implements RouteLocator {
    private final NodeFactory<Address> factory;
    private final Registry<String, Void> registry;
    private final Cache<String, ?> cache;
    private final boolean preferPrimary;
    private final String localRoute;

    public PrimaryOwnerRouteLocator(PrimaryOwnerRouteLocatorConfiguration config) {
        this.cache = config.getCache();
        this.registry = config.getRegistry();
        this.factory = config.getMemberFactory();
        CacheMode mode = config.getCache().getCacheConfiguration().clustering().cacheMode();
        this.preferPrimary = mode.needsStateTransfer() && !mode.isScattered();
        this.localRoute = (String)this.registry.getEntry(this.registry.getGroup().getLocalMember()).getKey();
    }

    public String locate(String sessionId) {
        Address primaryAddress = this.preferPrimary ? this.cache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)new Key((Object)sessionId)).primary() : null;
        Node primaryMember = primaryAddress != null ? this.factory.createNode(primaryAddress) : null;
        Map.Entry entry = primaryMember != null ? this.registry.getEntry(primaryMember) : null;
        return entry != null ? (String)entry.getKey() : this.localRoute;
    }
}

