/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.sasl.anonymous.AnonymousServerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;

public abstract class AbstractStreamServerService
implements Service<AcceptingChannel<StreamConnection>> {
    private final InjectedValue<org.jboss.as.domain.management.SecurityRealm> securityRealm = new InjectedValue();
    private final InjectedValue<SaslAuthenticationFactory> saslAuthenticationFactory = new InjectedValue();
    private final InjectedValue<SSLContext> sslContext = new InjectedValue();
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<SocketBindingManager> socketBindingManagerValue = new InjectedValue();
    private final OptionMap connectorPropertiesOptionMap;
    private volatile AcceptingChannel<StreamConnection> streamServer;
    private volatile ManagedBinding managedBinding;

    AbstractStreamServerService(OptionMap connectorPropertiesOptionMap) {
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public AcceptingChannel<StreamConnection> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.streamServer;
    }

    public Injector<org.jboss.as.domain.management.SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealm;
    }

    public Injector<SaslAuthenticationFactory> getSaslAuthenticationFactoryInjector() {
        return this.saslAuthenticationFactory;
    }

    public Injector<SSLContext> getSSLContextInjector() {
        return this.sslContext;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<SocketBindingManager> getSocketBindingManagerInjector() {
        return this.socketBindingManagerValue;
    }

    public void start(StartContext context) throws StartException {
        try {
            InjectedValue<SaslAuthenticationFactory> saslFactoryValue;
            SaslAuthenticationFactory factory;
            NetworkServerProvider networkServerProvider = (NetworkServerProvider)((Endpoint)this.endpointValue.getValue()).getConnectionProviderInterface("remoting", NetworkServerProvider.class);
            org.jboss.as.domain.management.SecurityRealm securityRealm = (org.jboss.as.domain.management.SecurityRealm)this.securityRealm.getOptionalValue();
            SSLContext sslContext = (SSLContext)this.sslContext.getOptionalValue();
            if (sslContext == null && securityRealm != null) {
                sslContext = securityRealm.getSSLContext();
            }
            OptionMap.Builder builder = OptionMap.builder();
            if (sslContext != null) {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
            }
            if ((factory = (SaslAuthenticationFactory)(saslFactoryValue = this.saslAuthenticationFactory).getOptionalValue()) == null && securityRealm != null) {
                Boolean policyNonanonymous;
                String[] mechanismNames = null;
                if (this.connectorPropertiesOptionMap.contains(Options.SASL_MECHANISMS)) {
                    Sequence sequence = (Sequence)this.connectorPropertiesOptionMap.get(Options.SASL_MECHANISMS);
                    mechanismNames = (String[])sequence.toArray((Object[])new String[sequence.size()]);
                }
                Boolean bl = policyNonanonymous = mechanismNames == null ? null : Boolean.valueOf(true);
                if (this.connectorPropertiesOptionMap.contains(Options.SASL_POLICY_NOANONYMOUS)) {
                    policyNonanonymous = (boolean)((Boolean)this.connectorPropertiesOptionMap.get(Options.SASL_POLICY_NOANONYMOUS));
                }
                factory = mechanismNames != null || policyNonanonymous != null ? securityRealm.getSaslAuthenticationFactory(mechanismNames, policyNonanonymous) : securityRealm.getSaslAuthenticationFactory();
                if (securityRealm.getSupportedAuthenticationMechanisms().contains(AuthMechanism.CLIENT_CERT)) {
                    builder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
                }
            }
            if (this.connectorPropertiesOptionMap != null) {
                builder.addAll(this.connectorPropertiesOptionMap);
            }
            OptionMap resultingMap = builder.getMap();
            if (RemotingLogger.ROOT_LOGGER.isTraceEnabled()) {
                RemotingLogger.ROOT_LOGGER.tracef("Resulting OptionMap %s", resultingMap.toString());
            }
            if (factory == null) {
                RemotingLogger.ROOT_LOGGER.warn("****** All authentication is ANONYMOUS for " + this.getClass().getName());
                SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
                domainBuilder.setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance());
                domainBuilder.addRealm("default", SecurityRealm.EMPTY_REALM).build();
                domainBuilder.setDefaultRealmName("default");
                factory = SaslAuthenticationFactory.builder().setFactory((SaslServerFactory)new AnonymousServerFactory()).setMechanismConfigurationSelector(i -> MechanismConfiguration.EMPTY).setSecurityDomain(domainBuilder.build()).build();
            }
            this.streamServer = networkServerProvider.createServer((SocketAddress)this.getSocketAddress(), resultingMap, factory, sslContext);
            SocketBindingManager sbm = (SocketBindingManager)this.socketBindingManagerValue.getOptionalValue();
            if (sbm != null) {
                this.managedBinding = this.registerSocketBinding(sbm);
            }
            RemotingLogger.ROOT_LOGGER.listeningOnSocket(NetworkUtils.formatAddress((InetSocketAddress)this.getSocketAddress()));
        }
        catch (BindException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotBindToSocket(e.getMessage() + " " + NetworkUtils.formatAddress((InetSocketAddress)this.getSocketAddress()), e);
        }
        catch (Exception e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStart(e);
        }
    }

    public void stop(StopContext context) {
        IoUtils.safeClose(this.streamServer);
        SocketBindingManager sbm = (SocketBindingManager)this.socketBindingManagerValue.getOptionalValue();
        if (sbm != null && this.managedBinding != null) {
            this.unregisterSocketBinding(this.managedBinding, sbm);
        }
    }

    abstract InetSocketAddress getSocketAddress();

    abstract ManagedBinding registerSocketBinding(SocketBindingManager var1);

    abstract void unregisterSocketBinding(ManagedBinding var1, SocketBindingManager var2);
}

