/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;

public class ScopedState {
    private final String scope;
    private final String name;

    public ScopedState(String scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopedState that = (ScopedState)o;
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.scope != null ? this.scope.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScopedState{scope='" + this.scope + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<ScopedState> {
        private static final long serialVersionUID = 326802903448963450L;

        public Integer getId() {
            return 133;
        }

        public Set<Class<? extends ScopedState>> getTypeClasses() {
            return Collections.singleton(ScopedState.class);
        }

        public void writeObject(ObjectOutput output, ScopedState object) throws IOException {
            output.writeUTF(object.scope);
            output.writeUTF(object.name);
        }

        public ScopedState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String scope = input.readUTF();
            String name = input.readUTF();
            return new ScopedState(scope, name);
        }
    }
}

