/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class LocalNameResolvingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ResolveType resolveType;

    public LocalNameResolvingHandler(HttpHandler next) {
        this.next = next;
        this.resolveType = ResolveType.FORWARD_AND_REVERSE;
    }

    public LocalNameResolvingHandler(HttpHandler next, ResolveType resolveType) {
        this.next = next;
        this.resolveType = resolveType;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        block9: {
            final InetSocketAddress address = exchange.getDestinationAddress();
            if (address != null) {
                if ((this.resolveType == ResolveType.FORWARD || this.resolveType == ResolveType.FORWARD_AND_REVERSE) && address.isUnresolved()) {
                    try {
                        if (System.getSecurityManager() == null) {
                            InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                            exchange.setDestinationAddress(resolvedAddress);
                            break block9;
                        }
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws UnknownHostException {
                                InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                                exchange.setDestinationAddress(resolvedAddress);
                                return null;
                            }
                        });
                    }
                    catch (UnknownHostException e) {
                        UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Could not resolve hostname %s", (Object)address.getHostString());
                    }
                } else if (this.resolveType == ResolveType.REVERSE || this.resolveType == ResolveType.FORWARD_AND_REVERSE) {
                    if (System.getSecurityManager() == null) {
                        address.getHostName();
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                address.getHostName();
                                return null;
                            }
                        });
                    }
                    exchange.setDestinationAddress(address);
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new LocalNameResolvingHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "resolve-local-name";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }

    public static enum ResolveType {
        FORWARD,
        REVERSE,
        FORWARD_AND_REVERSE;

    }
}

