/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;

public class HandlerUtil {
    static void checkNoOtherHandlerWithTheSameName(OperationContext context) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        Resource resource = context.readResourceFromRoot(parentAddress);
        PathElement element = address.getLastElement();
        String handlerType = element.getKey();
        String handlerName = element.getValue();
        for (String otherHandler : AuditLogHandlerResourceDefinition.HANDLER_TYPES) {
            PathElement check;
            if (handlerType.equals(otherHandler) || !resource.hasChild(check = PathElement.pathElement((String)otherHandler, (String)handlerName))) continue;
            throw DomainManagementLogger.ROOT_LOGGER.handlerAlreadyExists(check.getValue(), parentAddress.append(new PathElement[]{check}));
        }
    }

    static boolean lookForHandler(OperationContext context, PathAddress addr, String name) {
        PathAddress subAddress = addr.subAddress(0, addr.size() - 2);
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        for (String handlerType : AuditLogHandlerResourceDefinition.HANDLER_TYPES) {
            PathAddress referenceAddress = subAddress.append(handlerType, name);
            if (!HandlerUtil.lookForResource(root, referenceAddress)) continue;
            return true;
        }
        return false;
    }

    static boolean lookForFormatter(OperationContext context, PathAddress addr, String name) {
        PathAddress referenceAddress = addr.subAddress(0, addr.size() - 1).append("json-formatter", name);
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        return HandlerUtil.lookForResource(root, referenceAddress);
    }

    private static boolean lookForResource(Resource root, PathAddress pathAddress) {
        Resource current = root;
        for (PathElement element : pathAddress) {
            if ((current = current.getChild(element)) != null) continue;
            return false;
        }
        return true;
    }
}

