/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

abstract class AbstractTrustManagerService
implements Service<TrustManager[]> {
    private volatile char[] keystorePassword;
    private volatile TrustManager[] theTrustManagers;
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplier = new InjectedValue();

    AbstractTrustManagerService(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.theTrustManagers = this.createTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (KeyStoreException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
        this.theTrustManagers = null;
    }

    public TrustManager[] getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theTrustManagers;
    }

    Injector<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplier;
    }

    protected char[] resolvePassword() {
        try {
            ClearPassword password;
            PasswordCredential credential;
            CredentialSource cs;
            ExceptionSupplier sourceSupplier = (ExceptionSupplier)this.credentialSourceSupplier.getOptionalValue();
            if (sourceSupplier != null && (cs = (CredentialSource)sourceSupplier.get()) != null && (credential = (PasswordCredential)cs.getCredential(PasswordCredential.class)) != null && (password = (ClearPassword)credential.getPassword(ClearPassword.class)) != null) {
                return password.getPassword();
            }
        }
        catch (Exception ex) {
            return this.keystorePassword;
        }
        return this.keystorePassword;
    }

    protected TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = this.loadTrustStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    protected abstract KeyStore loadTrustStore();

    static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "trust-manager";

        ServiceUtil() {
        }

        public static ServiceName createServiceName(ServiceName parentService) {
            return parentService.append(new String[]{SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<TrustManager[]> injector, ServiceName parentService) {
            sb.addDependency(ServiceUtil.createServiceName(parentService), TrustManager[].class, injector);
            return sb;
        }
    }
}

