/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class NonReentrantLock
implements Lock {
    private final Lock inner = new ReentrantLock();
    private Condition condition;

    @Override
    public synchronized void lock() {
        this.inner.lock();
        try {
            if (this.condition == null) {
                this.condition = this.inner.newCondition();
            } else {
                this.condition.awaitUninterruptibly();
            }
        }
        finally {
            this.inner.unlock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.inner.lockInterruptibly();
        try {
            if (this.condition == null) {
                this.condition = this.inner.newCondition();
            } else {
                this.condition.await();
            }
        }
        finally {
            this.inner.unlock();
        }
    }

    @Override
    public boolean tryLock() {
        if (this.inner.tryLock()) {
            try {
                if (this.condition == null) {
                    this.condition = this.inner.newCondition();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.inner.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(time);
        if (this.inner.tryLock(time, unit)) {
            try {
                if (this.condition != null) {
                    long now = System.currentTimeMillis();
                    if (now >= deadline) {
                        boolean bl = false;
                        return bl;
                    }
                    this.condition.await(deadline - now, TimeUnit.MILLISECONDS);
                    boolean bl = true;
                    return bl;
                }
                this.condition = this.inner.newCondition();
            }
            finally {
                this.inner.unlock();
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        this.inner.lock();
        try {
            this.condition.signalAll();
            this.condition = null;
        }
        finally {
            this.inner.unlock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

