/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.RequestLogDTO;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

@XmlRootElement(name="web")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WebServerDTO
extends ComponentDTO {
    @XmlAttribute
    public String bind;
    @XmlAttribute(required=true)
    public String path;
    @XmlAttribute
    public Boolean clientAuth;
    @XmlAttribute
    public String passwordCodec;
    @XmlAttribute
    public String keyStorePath;
    @XmlAttribute
    public String trustStorePath;
    @XmlElementRef
    public List<AppDTO> apps;
    @XmlElementRef(required=false)
    public RequestLogDTO requestLog;
    @XmlAttribute
    private String keyStorePassword;
    @XmlAttribute
    private String trustStorePassword;

    public WebServerDTO() {
        this.componentClassName = "org.apache.activemq.artemis.component.WebServerComponent";
    }

    public String getKeyStorePassword() throws Exception {
        return this.getPassword(this.keyStorePassword);
    }

    private String getPassword(String password) throws Exception {
        return PasswordMaskingUtil.resolveMask(null, (String)password, (String)this.passwordCodec);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStorePassword() throws Exception {
        return this.getPassword(this.trustStorePassword);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }
}

