/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Utils;
import org.jboss.as.weld.webtier.jsp.WeldJspExpressionFactoryWrapper;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.module.web.servlet.ConversationFilter;
import org.jboss.weld.module.web.servlet.WeldInitialListener;
import org.jboss.weld.module.web.servlet.WeldTerminalListener;

public class WebIntegrationProcessor
implements DeploymentUnitProcessor {
    private final ListenerMetaData INITIAL_LISTENER_METADATA = new ListenerMetaData();
    private final ListenerMetaData TERMINAL_LISTENER_MEDATADA;
    private final FilterMetaData conversationFilterMetadata;
    private static final String WELD_INITIAL_LISTENER = WeldInitialListener.class.getName();
    private static final String WELD_TERMINAL_LISTENER = WeldTerminalListener.class.getName();
    private static final String WELD_SERVLET_LISTENER = "org.jboss.weld.environment.servlet.Listener";
    private static final String CONVERSATION_FILTER_CLASS = ConversationFilter.class.getName();
    private static final String CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    private static final ParamValueMetaData CONVERSATION_FILTER_INITIALIZED = new ParamValueMetaData();

    public WebIntegrationProcessor() {
        this.INITIAL_LISTENER_METADATA.setListenerClass(WELD_INITIAL_LISTENER);
        this.TERMINAL_LISTENER_MEDATADA = new ListenerMetaData();
        this.TERMINAL_LISTENER_MEDATADA.setListenerClass(WELD_TERMINAL_LISTENER);
        this.conversationFilterMetadata = new FilterMetaData();
        this.conversationFilterMetadata.setFilterClass(CONVERSATION_FILTER_CLASS);
        this.conversationFilterMetadata.setFilterName(CONVERSATION_FILTER_NAME);
        this.conversationFilterMetadata.setAsyncSupported(true);
        CONVERSATION_FILTER_INITIALIZED.setParamName(ConversationFilter.CONVERSATION_FILTER_REGISTERED);
        CONVERSATION_FILTER_INITIALIZED.setParamValue(Boolean.TRUE.toString());
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription module = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            WeldLogger.DEPLOYMENT_LOGGER.debug((Object)"Not installing Weld web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            WeldLogger.DEPLOYMENT_LOGGER.debug((Object)"Not installing Weld web tier integration as no merged web metadata found");
            return;
        }
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            if (WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
                this.createDependency(deploymentUnit, warMetaData);
            }
            return;
        }
        this.createDependency(deploymentUnit, warMetaData);
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        } else {
            ListIterator iterator = listeners.listIterator();
            while (iterator.hasNext()) {
                ListenerMetaData listener = (ListenerMetaData)iterator.next();
                if (!listener.getListenerClass().trim().equals(WELD_SERVLET_LISTENER)) continue;
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Removing weld servlet listener %s from web config, as it is not needed in EE6 environments", (Object)WELD_SERVLET_LISTENER);
                iterator.remove();
                break;
            }
        }
        listeners.add(0, this.INITIAL_LISTENER_METADATA);
        listeners.add(this.TERMINAL_LISTENER_MEDATADA);
        Utils.registerAsComponent(WELD_INITIAL_LISTENER, deploymentUnit);
        Utils.registerAsComponent(WELD_TERMINAL_LISTENER, deploymentUnit);
        deploymentUnit.addToAttachmentList(ExpressionFactoryWrapper.ATTACHMENT_KEY, (Object)WeldJspExpressionFactoryWrapper.INSTANCE);
        if (webMetaData.getContextParams() == null) {
            webMetaData.setContextParams(new ArrayList());
        }
        List contextParams = webMetaData.getContextParams();
        this.setupWeldContextIgnores(contextParams, "org.jboss.weld.context.ignore.forward");
        this.setupWeldContextIgnores(contextParams, "org.jboss.weld.context.ignore.include");
        if (webMetaData.getFilterMappings() != null) {
            boolean filterMappingFound = false;
            for (FilterMappingMetaData mapping : webMetaData.getFilterMappings()) {
                if (!CONVERSATION_FILTER_NAME.equals(mapping.getFilterName())) continue;
                filterMappingFound = true;
                break;
            }
            if (filterMappingFound) {
                boolean filterFound = false;
                if (webMetaData.getFilters() == null) {
                    webMetaData.setFilters(new FiltersMetaData());
                }
                for (FilterMetaData filter : webMetaData.getFilters()) {
                    if (!CONVERSATION_FILTER_CLASS.equals(filter.getFilterClass())) continue;
                    filterFound = true;
                    break;
                }
                if (!filterFound) {
                    webMetaData.getFilters().add((MappableMetaData)this.conversationFilterMetadata);
                    Utils.registerAsComponent(CONVERSATION_FILTER_CLASS, deploymentUnit);
                    webMetaData.getContextParams().add(CONVERSATION_FILTER_INITIALIZED);
                }
            }
        }
    }

    private void createDependency(DeploymentUnit deploymentUnit, WarMetaData warMetaData) {
        ServiceName weldStartService = (deploymentUnit.getParent() != null ? deploymentUnit.getParent() : deploymentUnit).getServiceName().append(WeldStartService.SERVICE_NAME);
        warMetaData.addAdditionalDependency(weldStartService);
    }

    private void setupWeldContextIgnores(List<ParamValueMetaData> contextParams, String parameterName) {
        for (ParamValueMetaData param : contextParams) {
            if (!parameterName.equals(param.getParamName())) continue;
            return;
        }
        ParamValueMetaData parameter = new ParamValueMetaData();
        parameter.setParamName(parameterName);
        parameter.setParamValue("false");
        contextParams.add(parameter);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

