/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bean.builtin.ee.StaticEEResourceProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessBeanAttributesImpl;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private final BeanManagerImpl manager;
    private final ServiceRegistry services;
    private final E environment;
    protected final ContainerLifecycleEvents containerLifecycleEvents;
    protected final ClassTransformer classTransformer;
    protected final SlimAnnotatedTypeStore slimAnnotatedTypeStore;
    protected final SpecializationAndEnablementRegistry specializationAndEnablementRegistry;
    protected final EjbSupport ejbSupport;

    public AbstractBeanDeployer(BeanManagerImpl manager, ServiceRegistry services, E environment) {
        this.manager = manager;
        this.services = services;
        this.environment = environment;
        this.containerLifecycleEvents = (ContainerLifecycleEvents)manager.getServices().get(ContainerLifecycleEvents.class);
        this.classTransformer = (ClassTransformer)services.get(ClassTransformer.class);
        this.slimAnnotatedTypeStore = (SlimAnnotatedTypeStore)services.get(SlimAnnotatedTypeStore.class);
        this.specializationAndEnablementRegistry = (SpecializationAndEnablementRegistry)services.get(SpecializationAndEnablementRegistry.class);
        this.ejbSupport = (EjbSupport)manager.getServices().getRequired(EjbSupport.class);
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    protected AbstractBeanDeployer<E> deploySpecialized() {
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), decoratorImpl);
            this.manager.addDecorator(decoratorImpl);
            BootstrapLogger.LOG.foundDecorator(decoratorImpl);
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), interceptorImpl);
            this.manager.addInterceptor(interceptorImpl);
            BootstrapLogger.LOG.foundInterceptor(interceptorImpl);
        }
        return this;
    }

    protected AbstractBeanDeployer<E> initializeBeans() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            bean.initialize((BeanDeployerEnvironment)this.getEnvironment());
        }
        return this;
    }

    protected AbstractBeanDeployer<E> fireProcessBeanEvents() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            if (bean instanceof NewBean) continue;
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), bean);
        }
        return this;
    }

    protected void processInjectionTargetEvents(Iterable<? extends AbstractBean<?, ?>> beans) {
        if (!this.containerLifecycleEvents.isProcessInjectionTargetObserved()) {
            return;
        }
        for (AbstractBean<?, ?> bean : beans) {
            if (bean instanceof NewBean || !(bean instanceof AbstractClassBean)) continue;
            this.containerLifecycleEvents.fireProcessInjectionTarget(this.getManager(), (AbstractClassBean)bean);
        }
    }

    protected void processProducerEvents(Iterable<? extends AbstractBean<?, ?>> beans) {
        if (!this.containerLifecycleEvents.isProcessProducerObserved()) {
            return;
        }
        for (AbstractBean<?, ?> bean : beans) {
            if (bean instanceof NewBean || !(bean instanceof AbstractProducerBean)) continue;
            this.containerLifecycleEvents.fireProcessProducer(this.getManager(), (AbstractProducerBean)Reflections.cast(bean));
        }
    }

    protected AbstractBeanDeployer<E> deployBeans() {
        this.manager.addBeans(((BeanDeployerEnvironment)this.getEnvironment()).getBeans());
        return this;
    }

    protected AbstractBeanDeployer<E> initializeObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            observerInitializer.initialize();
        }
        return this;
    }

    protected AbstractBeanDeployer<E> deployObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            BootstrapLogger.LOG.foundObserverMethod(observerInitializer.getObserver());
            ObserverMethod<?> processedObserver = this.containerLifecycleEvents.fireProcessObserverMethod(this.manager, observerInitializer.getObserver());
            if (processedObserver == null) continue;
            this.manager.addObserver(processedObserver);
        }
        return this;
    }

    protected <T> void createObserversProducersDisposers(AbstractClassBean<T> bean) {
        if (bean instanceof ManagedBean || bean instanceof SessionBean) {
            this.createDisposalMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerFields((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            if (this.manager.isBeanEnabled(bean)) {
                this.createObserverMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            }
        }
    }

    protected <X> DisposalMethod<X, ?> resolveDisposalMethod(BeanAttributes<?> attributes, AbstractClassBean<X> declaringBean) {
        Set<DisposalMethod<X, ?>> disposalBeans = ((BeanDeployerEnvironment)this.environment).resolveDisposalBeans(attributes.getTypes(), attributes.getQualifiers(), declaringBean);
        if (disposalBeans.size() == 1) {
            return disposalBeans.iterator().next();
        }
        if (disposalBeans.size() > 1) {
            throw BeanLogger.LOG.multipleDisposalMethods(this, WeldCollections.toMultiRowString(disposalBeans));
        }
        return null;
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> type) {
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : BeanMethods.filterMethods(type.getDeclaredEnhancedMethods(Produces.class))) {
            this.createProducerMethod(declaringBean, enhancedAnnotatedMethod);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : BeanMethods.filterMethods(annotatedClass.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class))) {
            DisposalMethod disposalBean = DisposalMethod.of(this.manager, enhancedAnnotatedMethod, declaringBean);
            ((BeanDeployerEnvironment)this.getEnvironment()).addDisposesMethod(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> annotatedMethod) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(annotatedMethod, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        ProducerMethod<X, T> bean = ProducerMethod.of(attributes, annotatedMethod, declaringBean, disposalMethod, this.manager, this.services);
        this.containerLifecycleEvents.preloadProcessBeanAttributes(bean.getType());
        this.containerLifecycleEvents.preloadProcessBean(ProcessProducerMethod.class, annotatedMethod.getBaseType(), bean.getBeanClass());
        this.containerLifecycleEvents.preloadProcessProducer(bean.getBeanClass(), annotatedMethod.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerMethod(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, EnhancedAnnotatedField<T, ? super X> field) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(field, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        EEResourceProducerField bean = EEResourceProducerField.isEEResourceProducerField(this.manager, field) ? (field.isStatic() ? StaticEEResourceProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services) : EEResourceProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services)) : ProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services);
        this.containerLifecycleEvents.preloadProcessBeanAttributes(bean.getType());
        this.containerLifecycleEvents.preloadProcessBean(ProcessProducerField.class, field.getBaseType(), bean.getBeanClass());
        this.containerLifecycleEvents.preloadProcessProducer(bean.getBeanClass(), field.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerField(bean);
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedField<?, X> field : annotatedClass.getDeclaredEnhancedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<? super X> annotatedClass) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, enhancedAnnotatedMethod, false);
        }
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getAsyncObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, enhancedAnnotatedMethod, true);
        }
    }

    protected <T, X> void createObserverMethod(AbstractClassBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> method, boolean isAsync) {
        ObserverMethodImpl<T, X> observer = ObserverFactory.create(method, declaringBean, this.manager, isAsync);
        ObserverInitializationContext<T, ? super X> observerInitializer = ObserverInitializationContext.of(observer, method);
        this.containerLifecycleEvents.preloadProcessObserverMethod(observer.getObservedType(), declaringBean.getBeanClass());
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserverMethod(observerInitializer);
    }

    protected <T> ManagedBean<T> createManagedBean(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        ManagedBean bean = ManagedBean.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(bean);
        return bean;
    }

    protected <T> void createNewManagedBean(Class<T> clazz, Type type) {
        EnhancedAnnotatedType<T> enhancedType = this.classTransformer.getEnhancedAnnotatedType(clazz, type, this.manager.getId());
        this.slimAnnotatedTypeStore.put(enhancedType.slim());
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(NewManagedBean.of(BeanAttributesFactory.forNewManagedBean(enhancedType, this.manager), enhancedType, this.manager));
    }

    protected <T> void createDecorator(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        DecoratorImpl bean = DecoratorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addDecorator(bean);
    }

    protected <T> void createInterceptor(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        InterceptorImpl bean = InterceptorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addInterceptor(bean);
    }

    public E getEnvironment() {
        return this.environment;
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addBuiltInBean(bean);
    }

    protected void addExtension(ExtensionBean bean) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addExtension(bean);
    }

    protected <T, S> boolean fireProcessBeanAttributes(AbstractBean<T, S> bean) {
        if (!this.specializationAndEnablementRegistry.isCandidateForLifecycleEvent(bean)) {
            return false;
        }
        ProcessBeanAttributesImpl event = this.containerLifecycleEvents.fireProcessBeanAttributes(this.getManager(), bean, bean.getAnnotated(), bean.getType());
        if (event == null) {
            return false;
        }
        if (event.isVeto()) {
            return true;
        }
        if (event.isDirty()) {
            bean.setAttributes(ExternalBeanAttributesFactory.of(event.getBeanAttributesInternal(), (BeanManager)this.manager));
            bean.checkSpecialization();
        }
        if (event.isIgnoreFinalMethods()) {
            bean.setIgnoreFinalMethods();
        }
        return false;
    }
}

