/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.ClientPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRequestMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeginMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationResponseMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationStartSyncMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage_1X;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage_V2;

public class ServerPacketDecoder
extends ClientPacketDecoder {
    private static final long serialVersionUID = 3348673114388400766L;

    private SessionSendMessage decodeSessionSendMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        Object sendMessage = connection.isVersionBeforeAddressChange() ? new SessionSendMessage_1X(new CoreMessage(this.coreMessageObjectPools)) : (connection.isVersionBeforeAsyncResponseChange() ? new SessionSendMessage(new CoreMessage(this.coreMessageObjectPools)) : new SessionSendMessage_V2(new CoreMessage(this.coreMessageObjectPools)));
        sendMessage.decode(in);
        return sendMessage;
    }

    private static SessionAcknowledgeMessage decodeSessionAcknowledgeMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionAcknowledgeMessage acknowledgeMessage = new SessionAcknowledgeMessage();
        acknowledgeMessage.decode(in);
        return acknowledgeMessage;
    }

    private static SessionRequestProducerCreditsMessage decodeRequestProducerCreditsMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionRequestProducerCreditsMessage requestProducerCreditsMessage = new SessionRequestProducerCreditsMessage();
        requestProducerCreditsMessage.decode(in);
        return requestProducerCreditsMessage;
    }

    private static SessionConsumerFlowCreditMessage decodeSessionConsumerFlowCreditMessage(ActiveMQBuffer in, CoreRemotingConnection connection) {
        SessionConsumerFlowCreditMessage sessionConsumerFlowCreditMessage = new SessionConsumerFlowCreditMessage();
        sessionConsumerFlowCreditMessage.decode(in);
        return sessionConsumerFlowCreditMessage;
    }

    public Packet decode(ActiveMQBuffer in, CoreRemotingConnection connection) {
        byte packetType = in.readByte();
        switch (packetType) {
            case 71: {
                return this.decodeSessionSendMessage(in, connection);
            }
            case 41: {
                return ServerPacketDecoder.decodeSessionAcknowledgeMessage(in, connection);
            }
            case 79: {
                return ServerPacketDecoder.decodeRequestProducerCreditsMessage(in, connection);
            }
            case 70: {
                return ServerPacketDecoder.decodeSessionConsumerFlowCreditMessage(in, connection);
            }
        }
        return this.slowPathDecode(in, packetType, connection);
    }

    private Packet slowPathDecode(ActiveMQBuffer in, byte packetType, CoreRemotingConnection connection) {
        PacketImpl packet;
        switch (packetType) {
            case 72: {
                packet = new SessionSendLargeMessage((Message)new CoreMessage());
                break;
            }
            case 91: {
                packet = new ReplicationAddMessage();
                break;
            }
            case 92: {
                packet = new ReplicationAddTXMessage();
                break;
            }
            case 93: {
                packet = new ReplicationDeleteMessage();
                break;
            }
            case 94: {
                packet = new ReplicationDeleteTXMessage();
                break;
            }
            case 95: {
                packet = new ReplicationPrepareMessage();
                break;
            }
            case 96: {
                packet = new ReplicationCommitMessage();
                break;
            }
            case 90: {
                packet = new ReplicationResponseMessage();
                break;
            }
            case -9: {
                packet = new ReplicationResponseMessageV2();
                break;
            }
            case 97: {
                packet = new ReplicationPageWriteMessage();
                break;
            }
            case 98: {
                packet = new ReplicationPageEventMessage();
                break;
            }
            case 99: {
                packet = new ReplicationLargeMessageBeginMessage();
                break;
            }
            case 100: {
                packet = new ReplicationLargeMessageEndMessage();
                break;
            }
            case 101: {
                packet = new ReplicationLargeMessageWriteMessage();
                break;
            }
            case 115: {
                packet = new BackupRegistrationMessage();
                break;
            }
            case 116: {
                packet = new BackupReplicationStartFailedMessage();
                break;
            }
            case 120: {
                packet = new ReplicationStartSyncMessage();
                break;
            }
            case 103: {
                packet = new ReplicationSyncFileMessage();
                break;
            }
            case 121: {
                packet = new ReplicationLiveIsStoppingMessage();
                break;
            }
            case 125: {
                packet = new ClusterConnectMessage();
                break;
            }
            case 126: {
                packet = new ClusterConnectReplyMessage();
                break;
            }
            case 111: {
                packet = new NodeAnnounceMessage();
                break;
            }
            case 127: {
                packet = new BackupRequestMessage();
                break;
            }
            case -1: {
                packet = new BackupResponseMessage();
                break;
            }
            case -2: {
                packet = new QuorumVoteMessage();
                break;
            }
            case -3: {
                packet = new QuorumVoteReplyMessage();
                break;
            }
            case -6: {
                packet = new ScaleDownAnnounceMessage();
                break;
            }
            default: {
                packet = super.decode(packetType, connection);
            }
        }
        packet.decode(in);
        return packet;
    }
}

