/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.jboss.logging.Logger;

public class DivertImpl
implements Divert {
    private static final Logger logger = Logger.getLogger(DivertImpl.class);
    private final PostOffice postOffice;
    private final SimpleString forwardAddress;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private final Filter filter;
    private final Transformer transformer;
    private final StorageManager storageManager;
    private final ComponentConfigurationRoutingType routingType;

    public DivertImpl(SimpleString forwardAddress, SimpleString uniqueName, SimpleString routingName, boolean exclusive, Filter filter, Transformer transformer, PostOffice postOffice, StorageManager storageManager, ComponentConfigurationRoutingType routingType) {
        this.forwardAddress = forwardAddress;
        this.uniqueName = uniqueName;
        this.routingName = routingName;
        this.exclusive = exclusive;
        this.filter = filter;
        this.transformer = transformer;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.routingType = routingType;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Diverting message " + message + " into " + this));
        }
        context.setReusable(false);
        Message copy = null;
        if (!this.forwardAddress.equals((Object)context.getAddress(message))) {
            long id = this.storageManager.generateID();
            copy = message.copy(id);
            copy.referenceOriginalMessage(message, this.getUniqueName().toString());
            copy.setAddress(this.forwardAddress);
            copy.setExpiration(message.getExpiration());
            copy.reencode();
            switch (this.routingType) {
                case ANYCAST: {
                    copy.setRoutingType(RoutingType.ANYCAST);
                    break;
                }
                case MULTICAST: {
                    copy.setRoutingType(RoutingType.MULTICAST);
                    break;
                }
                case STRIP: {
                    copy.setRoutingType(null);
                    break;
                }
            }
            if (this.transformer != null) {
                copy = this.transformer.transform(copy);
            }
            copy.messageChanged();
        } else {
            copy = message;
        }
        this.postOffice.route(copy, new RoutingContextImpl(context.getTransaction()).setReusable(false), false);
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) throws Exception {
        this.route(message, context);
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    public String toString() {
        return "DivertImpl [routingName=" + this.routingName + ", uniqueName=" + this.uniqueName + ", forwardAddress=" + this.forwardAddress + ", exclusive=" + this.exclusive + ", filter=" + this.filter + ", transformer=" + this.transformer + "]";
    }
}

