/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.client.InfinispanClientRequirement;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class RemoteCacheServiceConfigurator<K, V>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<RemoteCache<K, V>>,
Consumer<RemoteCache<K, V>> {
    private final String containerName;
    private final String cacheName;
    private final String configurationName;
    private final Function<ClientListenerNotifier, NearCacheService<K, V>> nearCacheFactory;
    private volatile SupplierDependency<RemoteCacheContainer> container;

    public RemoteCacheServiceConfigurator(ServiceName name, String containerName, String cacheName, String configurationName, Function<ClientListenerNotifier, NearCacheService<K, V>> nearCacheFactory) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
        this.configurationName = configurationName;
        this.nearCacheFactory = nearCacheFactory;
    }

    @Override
    public RemoteCache<K, V> get() {
        RemoteCacheContainer container = (RemoteCacheContainer)this.container.get();
        try (RemoteCacheContainer.NearCacheRegistration registration = this.nearCacheFactory != null ? container.registerNearCacheFactory(this.cacheName, this.nearCacheFactory) : null;){
            RemoteCache cache = container.getConfiguration().version().compareTo((Enum)ProtocolVersion.PROTOCOL_VERSION_27) >= 0 ? container.administration().getOrCreateCache(this.cacheName, this.configurationName) : container.getCache(this.cacheName);
            cache.start();
            RemoteCache remoteCache = cache;
            return remoteCache;
        }
    }

    @Override
    public void accept(RemoteCache<K, V> cache) {
        cache.stop();
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.container = new ServiceSupplierDependency(InfinispanClientRequirement.REMOTE_CONTAINER.getServiceName(support, this.containerName));
        return this;
    }

    public final ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        Consumer cache = this.container.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(cache, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

